/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.kernel.modules.http;

import jp.maru.liquid.kernel.modules.http.HttpCoreRequest;
import jp.maru.liquid.kernel.modules.http.HttpCoreResponse;
import jp.maru.liquid.kernel.modules.http.HttpGenericListener;
import jp.maru.liquid.kernel.modules.http.SessionGenerator;
import jp.maru.liquid.plugin.http.Cookie;
import jp.maru.liquid.plugin.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpListener
implements HttpGenericListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHttpListener.class);
    public static final String LIQUID_HTTP_SESSION_ID = "liquidsessionid";
    private HttpCoreRequest _request;
    private HttpCoreResponse _response;

    public DefaultHttpListener(HttpCoreRequest request, HttpCoreResponse response) {
        this._request = request;
        this._response = response;
    }

    @Override
    public void beforeGetSession(boolean create) {
        Cookie[] cookies = this._request.getCookies();
        HttpSession session = null;
        SessionGenerator sessionGenerator = SessionGenerator.getInstance();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!LIQUID_HTTP_SESSION_ID.equals(cookie.getName())) continue;
                session = sessionGenerator.get(cookie.getValue());
                if (!logger.isDebugEnabled() || session == null) break;
                logger.debug("Restore session ->" + session.getId());
                break;
            }
        }
        if (session == null && create) {
            session = sessionGenerator.generate();
            Cookie sessionCookie = new Cookie(LIQUID_HTTP_SESSION_ID, session.getId());
            sessionCookie.setPath("/");
            this._response.addCookie(sessionCookie);
            if (logger.isDebugEnabled()) {
                logger.debug("Create session -> " + session.getId());
            }
        }
        this._request.setSession(session);
    }
}

