/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.kernel.modules.http;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import jp.maru.liquid.kernel.modules.http.NestedEventListener;
import jp.maru.liquid.plugin.HttpServerCommonPlugin;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.nio.DefaultServerIOEventDispatch;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.protocol.AsyncNHttpServiceHandler;
import org.apache.http.nio.protocol.EventListener;
import org.apache.http.nio.protocol.NHttpRequestHandler;
import org.apache.http.nio.protocol.NHttpRequestHandlerRegistry;
import org.apache.http.nio.protocol.NHttpRequestHandlerResolver;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnector {
    private static final Logger logger = LoggerFactory.getLogger(HttpConnector.class);
    private NHttpRequestHandlerRegistry _registry;
    private NestedEventListener _eventListener;
    private int _port = 80;
    private int _timeout = 15000;
    private int _socketBufferSize = 8192;
    private int _workers = 5;
    private boolean _listened;

    public boolean isListened() {
        return this._listened;
    }

    public void listen() {
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.timeout", this._timeout).setIntParameter("http.socket.buffer-size", this._socketBufferSize).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)"Liquid HttpConnector/0.5.2");
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        AsyncNHttpServiceHandler handler = new AsyncNHttpServiceHandler((HttpProcessor)httpproc, (HttpResponseFactory)new DefaultHttpResponseFactory(), (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpParams)params);
        this._registry = new NHttpRequestHandlerRegistry();
        handler.setHandlerResolver((NHttpRequestHandlerResolver)this._registry);
        this._eventListener = new NestedEventListener();
        handler.setEventListener((EventListener)this._eventListener);
        DefaultServerIOEventDispatch ioEventDispatch = new DefaultServerIOEventDispatch((NHttpServiceHandler)handler, (HttpParams)params);
        new Thread((HttpParams)params, (IOEventDispatch)ioEventDispatch){
            final /* synthetic */ HttpParams val$params;
            final /* synthetic */ IOEventDispatch val$ioEventDispatch;
            {
                this.val$params = httpParams;
                this.val$ioEventDispatch = iOEventDispatch;
            }

            @Override
            public void run() {
                while (true) {
                    try {
                        DefaultListeningIOReactor ioReactor = new DefaultListeningIOReactor(HttpConnector.this._workers, this.val$params);
                        ioReactor.listen((SocketAddress)new InetSocketAddress(HttpConnector.this._port));
                        ioReactor.execute(this.val$ioEventDispatch);
                    }
                    catch (IOReactorException iore) {
                        logger.error(iore.toString(), (Throwable)iore);
                    }
                    catch (Exception e) {
                        logger.error(e.toString(), (Throwable)e);
                    }
                    logger.info("HttpConnector re-listning on " + HttpConnector.this._port);
                }
            }
        }.start();
        logger.info("HttpConnector listning on " + this._port);
        this._listened = true;
    }

    public void register(HttpServerCommonPlugin plugin, NHttpRequestHandler handler) {
        this._registry.register(plugin.getBindURI(), handler);
        logger.info("URI Registered. " + plugin.getClass().getSimpleName() + " to " + plugin.getBindURI());
    }

    public void addEventListener(EventListener listner) {
        this._eventListener.addEventListener(listner);
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    public void setSocketBufferSize(int size) {
        this._socketBufferSize = size;
    }

    public void setWorkers(int count) {
        this._workers = count;
    }
}

