/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.kernel.modules.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.protocol.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedEventListener
implements EventListener {
    private static final Logger logger = LoggerFactory.getLogger(NestedEventListener.class);
    private List<EventListener> _listeners = new ArrayList<EventListener>();

    public void addEventListener(EventListener listener) {
        this._listeners.add(listener);
        logger.info("Add listener. " + listener.getClass().getSimpleName());
    }

    public void connectionOpen(NHttpConnection conn) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).connectionOpen(conn);
        }
    }

    public void connectionTimeout(NHttpConnection conn) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).connectionTimeout(conn);
        }
    }

    public void connectionClosed(NHttpConnection conn) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).connectionClosed(conn);
        }
    }

    public void fatalIOException(IOException ex, NHttpConnection conn) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).fatalIOException(ex, conn);
        }
    }

    public void fatalProtocolException(HttpException ex, NHttpConnection conn) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).fatalProtocolException(ex, conn);
        }
    }
}

