/* file name  : ChatAction.java
 * authors    : Kohji Tsujita
 * created    : 2009ǯ0901 1256ʬ40
 * copyright  : Kohji Tsujita
 *
 * modifications:
 *
 */
package chat.action;

import jp.maru.liquid.plugin.Plugin;
import jp.maru.liquid.core.plugins.http.annotation.Intercept;
import jp.maru.liquid.core.plugins.http.annotation.InjectPlugin;
import jp.maru.liquid.core.plugins.http.interceptor.PluginInterceptor;
import jp.maru.liquid.core.plugins.http.interceptor.PluginAware;
import chat.plugin.ChatPlugin;

@Intercept(PluginInterceptor.class)
@InjectPlugin(ChatPlugin.class)
public class ChatAction implements PluginAware
{
	private ChatPlugin _chatPlugin;
	private String _handle,_msg;

	public String index()
	{
		return "index.ftl";
	}

	public String jquery()
	{
		return "jquery.min.js";
	}

	public String msg()
	{
		_chatPlugin.message(_handle,_msg);

		return "dummy.ftl";
	}


	public void setHandle(String handle)
	{
		_handle=handle;
	}

	public void setMsg(String msg)
	{
		_msg=msg;
	}

	@Override
	public void setPlugin(Plugin[] plugins)
	{
		_chatPlugin=(ChatPlugin)plugins[0];
	}
}
