/**
 * @file  DragDrop.cpp
 * @brief OLE Drag & Drop NX.
 *
 * @author JIN
 *
 * Copyright (C) 2009- JIN All rights reserved.
 */
#include "StdAfx.h"

#include "DragDrop.h"
#include "GlobalAlloc.h"

namespace GenericUtility {

	namespace {

		/// eLXgp̃tH[}bg
#ifdef _UNICODE
		static const UINT TEXT_FORMAT = CF_UNICODETEXT;
#else	// #ifdef _UNICODE
		static const UINT TEXT_FORMAT = CF_TEXT;
#endif	// #ifdef _UNICODE

		////////////////////////////////////////////////////////////////////////////////

		/**
		 * COleDataSource X^bNō쐬ƁA~CCmdTarget()  ASSERT(m_dwRef <= 1) Ɉ.
		 * 邽߂̃wp[NX.
		 */
		class CAutoOleDataSource
		{
		public:
			CAutoOleDataSource() : m_pDataDsource(new COleDataSource)
			{
			}
			~CAutoOleDataSource()
			{
				if (m_pDataDsource) {
					m_pDataDsource->InternalRelease();
				}
			}

			/**
			 * @see COleDataSource::CacheGlobalData().
			 */
			bool CacheGlobalData(
				CLIPFORMAT cfFormat,
				HGLOBAL hGlobal,
				LPFORMATETC lpFormatEtc = NULL)
			{
				if (!m_pDataDsource)
					return false;

				m_pDataDsource->CacheGlobalData(cfFormat, hGlobal, lpFormatEtc);

				return true;
			}

			/**
			 * @see COleDataSource::DoDragDrop().
			 */
			DROPEFFECT DoDragDrop(
				DWORD dwEffects = DROPEFFECT_COPY|DROPEFFECT_MOVE|DROPEFFECT_LINK,
				LPCRECT lpRectStartDrag = NULL,
				COleDropSource* pDropSource = NULL)
			{
				if (!m_pDataDsource)
					return DROPEFFECT_NONE;

				return m_pDataDsource->DoDragDrop(dwEffects, lpRectStartDrag, pDropSource);
			}

		private:
			COleDataSource* m_pDataDsource;
		};

		////////////////////////////////////////////////////////////////////////////////

		/**
		 * hbOf[^ǉNX.
		 * IAddDragData .
		 */
		class CAddDragData : public CDragDrop::IAddDragData
		{
		public:
			CAddDragData(CAutoOleDataSource& dataSource) : m_dataSource(dataSource)
			{
			}

			/**
			 * @see IAddDragData::AddBitmap().
			 */
			virtual bool AddBitmap(CBitmap& bitmap)
			{
				// 쐬f[^ݒ
				if (!m_dataSource.CacheGlobalData(CF_BITMAP, bitmap)) {
					return false;
				}
				// CacheGlobalData()  Detach Ă悢
				bitmap.Detach();

				return true;
			}

			/**
			 * @see IAddDragData::AddText().
			 */
			virtual bool AddText(LPCTSTR lpszText)
			{
				// m
				CGlobalAlloc ga(lpszText);
				if (!ga) {
					return false;
				}

				// 쐬f[^ݒ
				if (!m_dataSource.CacheGlobalData(TEXT_FORMAT, ga)) {
					return false;
				}
				// CacheGlobalData()  Detach Ă悢
				ga.Detach();

				return true;
			}

			/**
			 * @see IAddDragData::AddFiles().
			 */
			virtual bool AddFiles(const std::vector<CString>& fileNames)
			{
				// m
				CGlobalAlloc ga(fileNames);
				if (!ga) {
					return false;
				}

				// 쐬f[^ݒ
				if (!m_dataSource.CacheGlobalData(CF_HDROP, ga)) {
					return false;
				}
				// CacheGlobalData()  Detach Ă悢
				ga.Detach();

				return true;
			}

		private:
			CAutoOleDataSource& m_dataSource;
		};

		////////////////////////////////////////////////////////////////////////////////

		/**
		 * hbOf[^ǉ֐.
		 * IAddDragData gpăf[^ǉ.
		 * @see CDragDrop::AddDragDataFunc.
		 */
		class CAddDragDataFunc
		{
		public:
			/**
			 * rbg}bvf[^ǉ.
			 */
			static bool AddBitmap(CDragDrop::IAddDragData* addDragData, CBitmap& bitmap)
			{
				return addDragData && addDragData->AddBitmap(bitmap);
			}

			/**
			 * eLXgf[^ǉ.
			 */
			static bool AddText(CDragDrop::IAddDragData* addDragData, LPCTSTR lpszText)
			{
				return addDragData && addDragData->AddText(lpszText);
			}

			/**
			 * t@Cf[^ǉ.
			 */
			static bool AddFiles(CDragDrop::IAddDragData* addDragData, const std::vector<CString>& fileNames)
			{
				return addDragData && addDragData->AddFiles(fileNames);
			}
		};

	}	// anonymous namespace

	////////////////////////////////////////////////////////////////////////////////

	bool CDragDrop::DragData(const AddDragDataFunc& func)
	{
		if (!func) {
			return false;
		}

		// f[^\[XIuWFNg
		CAutoOleDataSource dataSource;

		// hbOf[^ǉNX
		CAddDragData addDragData(dataSource);

		// f[^ǉ
		if (!func(&addDragData)) {
			return false;
		}

		// Drag & Drop s
		DROPEFFECT result = dataSource.DoDragDrop(DROPEFFECT_COPY | DROPEFFECT_MOVE);
		switch (result) {
		// NȂ
		case DROPEFFECT_NONE:
			// TODO: true ԂׂH
			return false;
		// Rs[
		case DROPEFFECT_COPY:
			break;
		// ړ
		case DROPEFFECT_MOVE:
			// TODO: ړ폜
			break;
		default:
			return false;
		}

		return true;
	}

	bool CDragDrop::DragBitmap(CBitmap& bitmap)
	{
		return DragData(boost::bind(&CAddDragDataFunc::AddBitmap, _1, boost::ref(bitmap)));
	}

	bool CDragDrop::DragText(LPCTSTR lpszText)
	{
		return DragData(boost::bind(&CAddDragDataFunc::AddText, _1, lpszText));
	}

	bool CDragDrop::DragFiles(const std::vector<CString>& fileNames)
	{
		return DragData(boost::bind(&CAddDragDataFunc::AddFiles, _1, boost::ref(fileNames)));
	}

}	// namespace GenericUtility
