/**
 * @file  ProgressManager.cpp
 * @brief vOXǗNX.
 *
 * @author JIN
 *
 * Copyright (C) 2011- JIN All rights reserved.
 */
#include "StdAfx.h"
#include "ProgressManager.h"
#include "MathUtility.h"

namespace GenericUtility {

	CProgressManager::CProgressManager(const OnProgressFunc& onProgress)
		: m_onProgress(onProgress)
		, m_total(100)
		, m_current(0)
		, m_begin(0)
		, m_end(100)
		, m_lastProgress(~0)
	{
	}

	CProgressManager::~CProgressManager()
	{
		// Ilɂ
		SetProgress(m_end);
	}

	bool CProgressManager::SetProgressRange(size_t begin, size_t end)
	{
		if (begin >= end) {
			return false;
		}

		m_begin = begin;
		m_end   = end;
		m_lastProgress = ~0;

		return true;
	}

	bool CProgressManager::StartProgress(size_t total)
	{
		if (total <= 0) {
			return false;
		}

		m_total   = total;
		m_current = 0;

		// Jnlɂ
		SetProgress(m_begin);

		return true;
	}

	void CProgressManager::Increment(size_t increment)
	{
		// Kv͂Ȃ
		if (!m_onProgress) {
			return;
		}

		// vOXi߂Ēʒm
		m_current += increment;
		SetProgress(m_begin + (m_end - m_begin) * m_current / m_total);
	}

	void CProgressManager::EndProgress()
	{
		m_current = m_total;

		// Ilɂ
		SetProgress(m_end);
	}

	void CProgressManager::SetProgress(size_t progress)
	{
		// Kv͂Ȃ
		if (!m_onProgress) {
			return;
		}

		// HACK: m_begin ` m_end ɂ
		progress = Math::Round(progress, m_begin, m_end);

		// ܂\iłȂ
		if (m_lastProgress != ~0 && m_lastProgress >= progress) {
			return;
		}

		// vOX֐Ă
		m_onProgress(m_lastProgress = progress);
	}

}	// namespace GenericUtility
