/**
 * @file  ProgressManager.h
 * @brief vOXǗNX`.
 *
 * @author JIN
 *
 * Copyright (C) 2011- JIN All rights reserved.
 */
#pragma once

namespace GenericUtility {

	/**
	 * vOXǗ.
	 *
	 * // NUM_PROCESS ̏sAŜ 0 - 100 ̒ʒm
	 * for (i = 0; i < NUM_PROCESS; ++i) {
	 *   // ̒ʒmvOX͈͂ݒ肷
	 *   SetProgressRange(i*100/NUM_PROCESS, (i+1)*100/NUM_PROCESS);
	 *   // 񏈗f[^ݒ肷
	 *   StartProgress(NUM_DATA);
	 *   for (NUM_DATA) {
	 *     Increment();
	 *   }
	 *   EndProgress();
	 * }
	 */
	class CProgressManager
	{
	public:
		/// vOXʒm֐
		typedef boost::function<void(size_t /* vOX (m_begin ` m_end) */)> OnProgressFunc;

	public:
		CProgressManager(const OnProgressFunc& onProgress);
		~CProgressManager();

		/**
		 * vOX̒ʒm͈͂ݒ肷.
		 */
		bool SetProgressRange(size_t begin, size_t end);

		/**
		 * vOXJn.
		 * ݂̃vOX 0 ɃZbg.
		 */
		bool StartProgress(size_t total);
		/**
		 * ݂̃vOXi߂.
		 */
		void Increment(size_t increment = 1);
		/**
		 * vOXI.
		 */
		void EndProgress();

	private:
		/**
		 * vOXʒm.
		 */
		void SetProgress(
			/// [in] ʒmvOX (m_begin ` m_end)
			size_t progress);

	private:
		OnProgressFunc m_onProgress;

		/// g[^vOX (C)
		size_t m_total;
		/// ݂̃vOX (0 ` m_total)
		size_t m_current;

		/// ʒmvOXJnl
		size_t m_begin;
		/// ʒmvOXIl
		size_t m_end;
		/// ŌɒʒmʒmvOX (m_begin ` m_end)
		size_t m_lastProgress;
	};

	/**
	 * X̏̃vOX.
	 * (vOX͈͂łɐݒ肳Ă邱ƂO)
	 */
	class CAutoProgress
	{
	public:
		CAutoProgress(CProgressManager* pm, size_t total) : m_pm(pm)
		{
			if (m_pm) {
				m_pm->StartProgress(total);
			}
		}
		~CAutoProgress()
		{
			if (m_pm) {
				m_pm->EndProgress();
			}
		}

		/**
		 * ݂̃vOXi߂.
		 */
		void Increment(size_t increment = 1)
		{
			if (m_pm) {
				m_pm->Increment(increment);
			}
		}

	private:
		CProgressManager* m_pm;
	};

}	// namespace GenericUtility
