/**
 * @file  DataManager.h
 * @brief ListPaste f[^}l[WNX`.
 *
 * @author JIN
 *
 * Copyright (C) 2011- JIN All rights reserved.
 */
#pragma once

#include "../GenericLib/ProgressManager.h"

/// Search() ŃvOXLɂ
//#define DATAMANAGER_ENABLE_SEARCH_PROGRESS

namespace ListPasteLib {

	/**
	 * f[^O[v.
	 */
	class CDataGroup : boost::noncopyable
	{
	public:
		virtual ~CDataGroup() = 0 {}

		/**
		 * O[vݒ肷.
		 */
		virtual void SetName(const std::wstring& name) = 0;
		/**
		 * O[v擾.
		 */
		virtual const std::wstring& GetName() const = 0;

		/**
		 * ǉ.
		 * @param[in] index ǉʒu (>= eLXg: ɒǉ)
		 */
		virtual bool Add(size_t index, const std::wstring& text) = 0;
		/**
		 * ǉ.
		 * rɕǉꍇ́Axɒǉ.
		 * @param[in] index ǉʒu (>= eLXg: ɒǉ)
		 */
		virtual bool Add(size_t index, const std::vector<std::wstring>& texts) = 0;
		/**
		 * ύX.
		 */
		virtual bool Modify(size_t index, const std::wstring& text) = 0;
		/**
		 * 폜.
		 */
		virtual bool Delete(size_t index) = 0;

		typedef std::deque<std::wstring> WStrings;
		/**
		 * ׂẴeLXg擾.
		 */
		virtual const WStrings& GetTexts() const = 0;

		typedef boost::function<bool (const std::wstring& /* eXgΏە */)> MatchFunc;
		typedef std::vector<size_t> IndexVec;
		/**
		 * .
		 * @param[in]  func      eLXg}b`֐
		 * @param[in]  pProgress vOX (SetProgressRange() ς݂̂)
		 * @param[out] indices   }b`eLXg̃CfbNX
		 */
		virtual void Search(
			const MatchFunc& func,
			IndexVec& indices
#ifdef DATAMANAGER_ENABLE_SEARCH_PROGRESS
			, GenericUtility::CProgressManager* pProgress = NULL
#endif	// #ifdef DATAMANAGER_ENABLE_SEARCH_PROGRESS
			)
			const = 0;

		/**
		 * w肵CfbNX͈͓.
		 * @param[in]  begin     JnCfbNX
		 * @param[in]  end       ICfbNX (܂܂Ȃ)
		 * @param[in]  func      eLXg}b`֐
		 * @param[in]  pProgress vOX (StartProgress() ς݂̂)
		 * @param[out] indices   }b`eLXg̃CfbNX
		 */
		virtual void Search(
			size_t begin, size_t end,
			const MatchFunc& func,
			IndexVec& indices
#ifdef DATAMANAGER_ENABLE_SEARCH_PROGRESS
			, GenericUtility::CProgressManager* pProgress = NULL
#endif	// #ifdef DATAMANAGER_ENABLE_SEARCH_PROGRESS
			)
			const = 0;
	};

	////////////////////////////////////////////////////////////////////////////////

	typedef boost::shared_ptr<class CDataManager> CDataManagerPtr;

	/**
	 * f[^}l[W.
	 * @note ۑAǂݍ݂ Save/Load łȂ (boost::serialization ɒړnĂ͂ȂȂ; dirty flag ̂)
	 */
	class CDataManager : boost::noncopyable
	{
	public:
		virtual ~CDataManager() = 0 {}

	public:
		/**
		 * VACYăt@Cɕۑ.
		 * ύXtOɂ炸AۑȂ.
		 * ۑɐAύXtONA.
		 * @note gq ".xml" łȂ΁AoCiŕۑ
		 */
		virtual bool Save(const std::wstring& filename) const = 0;
		/**
		 * t@CǂݍŃfVACY.
		 * ǂݍ񂾌ɕύXtONA邪AftHgꂽ痧Ă.
		 * @note gq ".xml" łȂ΁AoCiƂēǂݍ
		 */
		virtual bool Load(const std::wstring& filename) = 0;

		// HACK: VKɃIuWFNg쐬Ȃ̂ŁAClone() ł͂Ȃ Copy() ɂĂ
		/**
		 * ɃRs[.
		 */
		virtual bool Copy(const CDataManagerPtr& manager) = 0;

	public:
		/**
		 * f[^O[v𖖔ɒǉ.
		 */
		virtual bool Add(const std::wstring& name) = 0;
		/**
		 * f[^O[v폜.
		 */
		virtual bool Delete(size_t index) = 0;
		/**
		 * index Ԗڂ̃f[^O[vړ.
		 * [邢͉[𒴂ꍇ́A[邢͉[ɂȂ.
		 * @param[in] nMove ړ (+: , -: )
		 * @return łړǂ.
		 */
		virtual bool Move(size_t index, INT_PTR nMove) = 0;
		/**
		 * f[^O[v𖼑OŌ.
		 * @return ŏ̃CfbNX (~0 : Ȃ)
		 */
		virtual size_t Find(const std::wstring& name) const = 0;

		/**
		 * f[^O[v擾.
		 */
		virtual size_t GetGroupCount() const = 0;

		/**
		 * i Ԗڂ̃f[^O[v擾.
		 */
		virtual CDataGroup& GetGroup(size_t index) = 0;
		/**
		 * i Ԗڂ̃f[^O[v擾.
		 */
		virtual const CDataGroup& GetGroup(size_t index) const = 0;

		/**
		 * ݂̃f[^O[v擾.
		 */
		virtual size_t GetCurrentGroupIndex() const = 0;
		/**
		 * ݂̃f[^O[vݒ肷.
		 * @param[in] setDirtyFlag ύXtO𗧂Ă
		 */
		virtual bool SetCurrentGroup(size_t index, bool setDirtyFlag) = 0;

		/**
		 * ݂̃f[^O[v擾.
		 */
		virtual CDataGroup& GetCurrentGroup() = 0;
		/**
		 * ݂̃f[^O[v擾.
		 */
		virtual const CDataGroup& GetCurrentGroup() const = 0;

		/**
		 * ύXĂ邩ǂ擾.
		 */
		virtual bool IsDirty() const = 0;

		////////////////////////////////////////////////////////////////////////////////
	public:
		/**
		 * CX^X쐬.
		 */
		static CDataManagerPtr CreateInstance();

		/**
		 * ftHgO[vݒ肷.
		 */
		static void SetDefaultGroupName(const std::wstring& name);
	};

}	// namespace ListPasteLib
