/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.crawler;

import java.util.Calendar;
import java.util.List;
import net.sourceforge.livepinger.crawler.CrawlException;
import net.sourceforge.livepinger.crawler.Crawler;
import net.sourceforge.livepinger.dto.Live;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CrawlManager
extends Thread {
    private static Log log = LogFactory.getLog(CrawlManager.class);
    OnCrawlStartListener crawlStartListener;
    OnCrawlDoneListener crawlDoneListener;
    boolean runningFlag = false;
    long nextInterval = 0L;
    long interval = 300000L;
    public static int WAIT_INTERVAL = 100;

    public CrawlManager(OnCrawlStartListener crawlStartListener, OnCrawlDoneListener crawlDoneListener) {
        this.crawlStartListener = crawlStartListener;
        this.crawlDoneListener = crawlDoneListener;
    }

    @Override
    public void run() {
        while (true) {
            long now;
            try {
                Thread.sleep(WAIT_INTERVAL);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((now = Calendar.getInstance().getTimeInMillis()) < this.nextInterval || !this.runningFlag) continue;
            this.nextInterval = now - now % this.interval + this.interval;
            log.info("[crawl schedule] now: " + now);
            log.info("[crawl schedule] next interval: " + this.nextInterval);
            log.info("[crawl schedule] crawl starts: ");
            if (this.crawlStartListener != null) {
                this.crawlStartListener.onCrawlStart();
            }
            Crawler crawler = new Crawler(this.crawlDoneListener);
            try {
                crawler.run();
            }
            catch (CrawlException crawlException) {
            }
        }
    }

    public void startCrawl() {
        this.nextInterval = 0L;
        this.runningFlag = true;
    }

    public void stopCrawl() {
        this.runningFlag = false;
    }

    public boolean isRunning() {
        return this.runningFlag;
    }

    public static interface OnCrawlDoneListener {
        public void onCrawlDone(List<Live> var1);
    }

    public static interface OnCrawlStartListener {
        public void onCrawlStart();
    }
}

