/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.dto;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.livepinger.dto.CavetubeLive;
import net.sourceforge.livepinger.dto.Live;

public class LivetubeLive
extends Live {
    public static String SERVICE_NAME = "Livetube.cc";
    public static String BASE_URL = "http://h.livetube.cc/";
    static Pattern URL_PATTERN = Pattern.compile("http://h\\.livetube\\.cc/[^/]+/([^/]+)");
    static Pattern IDENTIFIER_PATTERN = Pattern.compile("/([^/]+)/([^/]+)$");
    private static final String BACKGROUND_IMAGE_PATH = "/images/notifier_bg_livetube.png";
    private static Image backgroundImage = null;

    public LivetubeLive(String url, String identifier, String livename) {
        super(url, identifier, livename);
    }

    public static String getIdentifierFromUrl(String url) {
        Matcher matcher = IDENTIFIER_PATTERN.matcher(url);
        if (matcher.find() && matcher.groupCount() > 1) {
            try {
                return URLDecoder.decode(matcher.group(1), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public synchronized Image getBackgroundImageInstance() {
        if (backgroundImage == null) {
            URL url = CavetubeLive.class.getResource(BACKGROUND_IMAGE_PATH);
            backgroundImage = Toolkit.getDefaultToolkit().getImage(url);
        }
        return backgroundImage;
    }

    public static String getLivenameFromUrl(String url) {
        Matcher matcher = IDENTIFIER_PATTERN.matcher(url);
        if (matcher.find() && matcher.groupCount() > 1) {
            try {
                return URLDecoder.decode(matcher.group(2), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    public static boolean match(String url) {
        return URL_PATTERN.matcher(url).matches();
    }
}

