/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.extracter;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.livepinger.dto.Live;
import net.sourceforge.livepinger.dto.LivetubeLive;
import net.sourceforge.livepinger.extracter.ExtracterBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LivetubeExtracter
extends ExtracterBase {
    private static Log log = LogFactory.getLog(LivetubeExtracter.class);
    static String CRAWL_URL = "http://h.livetube.cc/";
    Pattern anchorPattern = Pattern.compile("<a href=\"/?([^\"]+)/([^\"]+)\">.*?</a>");
    Pattern livePattern = Pattern.compile("<b>.*?</b>.*?\\(([0-9]+):([0-9]+)\u8996,([0-9]+)\u30b3\\)");

    @Override
    public List<Live> extract(String data) {
        ArrayList<Live> lives = new ArrayList<Live>();
        Matcher anchorMatcher = this.anchorPattern.matcher(data);
        while (anchorMatcher.find()) {
            Matcher distMatcher = this.livePattern.matcher(anchorMatcher.group(0));
            if (!distMatcher.find()) continue;
            try {
                String distName = URLDecoder.decode(anchorMatcher.group(1), "UTF-8");
                String liveName = URLDecoder.decode(anchorMatcher.group(2), "UTF-8");
                log.info("[extract] distributor: " + distName);
                log.info("[extract] live: " + liveName);
                LivetubeLive live = new LivetubeLive(String.valueOf(LivetubeLive.BASE_URL) + anchorMatcher.group(1) + "/" + anchorMatcher.group(2), distName, liveName);
                live.setOnair(true);
                lives.add(live);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return lives;
    }

    @Override
    public String getCrawlUrl() {
        return CRAWL_URL;
    }
}

