/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.manager;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.sourceforge.livepinger.dto.Live;

public class TargetTable
extends JTable {
    private static final long serialVersionUID = 5358475357631917584L;
    List<Live> lives;
    ListSelectionListener listSelectionListener;

    public TargetTable(TableModel dm, List<Live> lives, ListSelectionListener listSelectionListener) {
        super(dm);
        this.lives = lives;
        this.listSelectionListener = listSelectionListener;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component component = super.prepareRenderer(renderer, row, column);
        if (this.lives == null || this.lives.size() <= row) {
            return component;
        }
        Live targetLive = this.lives.get(row);
        if (targetLive == null) {
            return component;
        }
        if (!this.isRowSelected(row)) {
            if (!targetLive.isOnair()) {
                component.setBackground(Color.LIGHT_GRAY);
            } else {
                component.setBackground(this.getBackground());
            }
        }
        return component;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.listSelectionListener.valueChanged(e);
    }
}

