/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.notifier;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import net.sourceforge.livepinger.dto.Live;
import net.sourceforge.livepinger.manager.Configuration;
import net.sourceforge.livepinger.notifier.NotifierButton;

public class NotifierFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -7325642653455831712L;
    Live live;
    Timer timer;
    static int WIDTH = 240;
    static int HEIGHT = 60;
    int index;

    public NotifierFrame(int index, Live live) {
        this.index = index;
        this.live = live;
        this.initialize();
    }

    private void initialize() {
        NotifierButton button = new NotifierButton(this.live.toString(), this.live.getBackgroundImageInstance());
        button.addActionListener(this);
        this.getContentPane().add(button);
        this.setUndecorated(true);
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        Dimension desktopSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(desktopSize.width - WIDTH, desktopSize.height - HEIGHT - this.index * HEIGHT, WIDTH, HEIGHT);
        this.setVisible(true);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new EndTimerTask(), Configuration.getInstance().getPopupLifeTime() * 1000);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(new URI(this.live.getUrl()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    class EndTimerTask
    extends TimerTask {
        EndTimerTask() {
        }

        @Override
        public void run() {
            WindowEvent wev = new WindowEvent(NotifierFrame.this, 201);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
        }
    }
}

