/*
 * Decompiled with CFR 0.152.
 */
package com.jsptags.navigation.pager;

import com.jsptags.navigation.pager.parser.PagerTagExport;
import com.jsptags.navigation.pager.parser.ParseException;
import com.jsptags.navigation.pager.parser.TagExportParser;
import java.net.URLEncoder;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class PagerTag
extends TagSupport {
    static final String DEFAULT_ID = "pager";
    private static final int DEFAULT_MAX_ITEMS = Integer.MAX_VALUE;
    private static final int DEFAULT_MAX_PAGE_ITEMS = 10;
    private static final int DEFAULT_MAX_INDEX_PAGES = 10;
    static final String OFFSET_PARAM = ".offset";
    static final String PAGE = "page";
    static final String REQUEST = "request";
    static final String CENTER = "center";
    static final String FORWARD = "forward";
    static final String HALF_FULL = "half-full";
    private String url;
    private String index;
    private int items;
    private int maxItems;
    private int maxPageItems;
    private int maxIndexPages;
    private boolean isOffset;
    private String export;
    private String scope;
    private StringBuffer uri;
    private int params;
    private int offset;
    private int itemCount;
    private int pageNumber;
    private Integer pageNumberInteger;
    private String idOffsetParam;
    private PagerTagExport pagerTagExport;
    private Object oldPager;
    private Object oldOffset;
    private Object oldPageNumber;

    public final void setId(String string) {
        super.setId(string);
        this.idOffsetParam = string + OFFSET_PARAM;
    }

    public final void setUrl(String string) {
        this.url = string;
    }

    public final String getUrl() {
        return this.url;
    }

    public final void setIndex(String string) throws JspException {
        if (!(string == null || CENTER.equals(string) || FORWARD.equals(string) || HALF_FULL.equals(string))) {
            throw new JspTagException("value for attribute \"index\" must be either \"center\", \"forward\" or \"half-full\".");
        }
        this.index = string;
    }

    public final String getIndex() {
        return this.index;
    }

    public final void setItems(int n) {
        this.items = n;
    }

    public final int getItems() {
        return this.items;
    }

    public final void setMaxItems(int n) {
        this.maxItems = n;
    }

    public final int getMaxItems() {
        return this.maxItems;
    }

    public final void setMaxPageItems(int n) {
        this.maxPageItems = n;
    }

    public final int getMaxPageItems() {
        return this.maxPageItems;
    }

    public final void setMaxIndexPages(int n) {
        this.maxIndexPages = n;
    }

    public final int getMaxIndexPages() {
        return this.maxIndexPages;
    }

    public final void setIsOffset(boolean bl) {
        this.isOffset = bl;
    }

    public final boolean getIsOffset() {
        return this.isOffset;
    }

    public final void setExport(String string) throws JspException {
        if (this.export != string) {
            try {
                this.pagerTagExport = TagExportParser.parsePagerTagExport(string);
            }
            catch (ParseException parseException) {
                throw new JspTagException(parseException.getMessage());
            }
        }
        this.export = string;
    }

    public final String getExport() {
        return this.export;
    }

    public final void setScope(String string) throws JspException {
        if (string != null && !PAGE.equals(string) && !REQUEST.equals(string)) {
            throw new JspTagException("value for attribute \"scope\" must be either \"page\" or \"request\".");
        }
        this.scope = string;
    }

    public final String getScope() {
        return this.scope;
    }

    final void addParam(String string, String string2) {
        if (string2 != null) {
            string = URLEncoder.encode(string);
            string2 = URLEncoder.encode(string2);
            this.uri.append(this.params == 0 ? (char)'?' : '&').append(string).append('=').append(string2);
            ++this.params;
        } else {
            String[] stringArray = this.pageContext.getRequest().getParameterValues(string);
            if (stringArray != null) {
                string = URLEncoder.encode(string);
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    string2 = URLEncoder.encode(stringArray[n]);
                    this.uri.append(this.params == 0 ? (char)'?' : '&').append(string).append('=').append(string2);
                    ++this.params;
                    ++n;
                }
            }
        }
    }

    final boolean nextItem() {
        boolean bl = false;
        if (this.itemCount < this.maxItems) {
            boolean bl2 = false;
            if (this.itemCount >= this.offset && this.itemCount < this.offset + this.maxPageItems) {
                bl2 = true;
            }
            bl = bl2;
            ++this.itemCount;
        }
        return bl;
    }

    final int getOffset() {
        return this.offset;
    }

    final boolean isIndexNeeded() {
        boolean bl = false;
        if (this.offset != 0 || this.getItemCount() > this.maxPageItems) {
            bl = true;
        }
        return bl;
    }

    final boolean hasPrevPage() {
        boolean bl = false;
        if (this.offset > 0) {
            bl = true;
        }
        return bl;
    }

    final boolean hasNextPage() {
        boolean bl = false;
        if (this.getItemCount() > this.getNextOffset()) {
            bl = true;
        }
        return bl;
    }

    final boolean hasPage(int n) {
        boolean bl = false;
        if (n >= 0 && this.getItemCount() > n * this.maxPageItems) {
            bl = true;
        }
        return bl;
    }

    final int getPrevOffset() {
        return Math.max(0, this.offset - this.maxPageItems);
    }

    final int getNextOffset() {
        return this.offset + this.maxPageItems;
    }

    final String getOffsetUrl(int n) {
        int n2 = this.uri.length();
        this.uri.append(this.params == 0 ? (char)'?' : '&').append(this.idOffsetParam).append('=').append(n);
        String string = this.uri.toString();
        this.uri.setLength(n2);
        return string;
    }

    final String getPageUrl(int n) {
        return this.getOffsetUrl(this.maxPageItems * n);
    }

    final Integer getOffsetPageNumber(int n) {
        return new Integer(1 + this.pageNumber(n));
    }

    final Integer getPageNumber(int n) {
        if (n == this.pageNumber) {
            return this.pageNumberInteger;
        }
        return new Integer(1 + n);
    }

    final int getPageNumber() {
        return this.pageNumber;
    }

    final int getPageCount() {
        return this.pageNumber(this.getItemCount());
    }

    final int getFirstIndexPage() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = this.maxIndexPages / 2;
        if (FORWARD.equals(this.index)) {
            n3 = Math.min(this.pageNumber + 1, this.getPageCount());
        } else if (!(HALF_FULL.equals(this.index) && this.pageNumber < n4 || (n2 = this.getPageCount()) <= this.maxIndexPages || (n = n2 - (n3 = Math.max(0, this.pageNumber - n4))) >= this.maxIndexPages)) {
            n3 -= this.maxIndexPages - n;
        }
        return n3;
    }

    final int getLastIndexPage(int n) {
        int n2 = this.getPageCount();
        int n3 = this.maxIndexPages / 2;
        int n4 = HALF_FULL.equals(this.index) && this.pageNumber < n3 ? this.pageNumber + n3 : n + this.maxIndexPages;
        return (n2 <= n4 ? n2 : n4) - 1;
    }

    final int getItemCount() {
        return this.items != 0 ? this.items : this.itemCount;
    }

    private final int pageNumber(int n) {
        int n2 = n / this.maxPageItems;
        int n3 = 0;
        if (n % this.maxPageItems == 0) {
            n3 = 1;
        }
        return n2 + (1 - n3);
    }

    public final int doStartTag() throws JspException {
        String string;
        if (this.url != null) {
            string = this.url;
        } else {
            string = ((HttpServletRequest)this.pageContext.getRequest()).getRequestURI();
            int n = string.indexOf(63);
            if (n != -1) {
                string = string.substring(0, n);
            }
        }
        if (this.uri == null) {
            this.uri = new StringBuffer(string.length() + 32);
        } else {
            this.uri.setLength(0);
        }
        this.uri.append(string);
        this.params = 0;
        this.offset = 0;
        this.itemCount = 0;
        String string2 = this.pageContext.getRequest().getParameter(this.idOffsetParam);
        if (string2 != null) {
            try {
                this.offset = Math.max(0, Integer.parseInt(string2));
                if (this.isOffset) {
                    this.itemCount = this.offset;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.pageNumber = this.pageNumber(this.offset);
        this.pageNumberInteger = new Integer(1 + this.pageNumber);
        if (REQUEST.equals(this.scope)) {
            ServletRequest servletRequest = this.pageContext.getRequest();
            this.oldPager = servletRequest.getAttribute(this.id);
            servletRequest.setAttribute(this.id, (Object)this);
            if (this.pagerTagExport != null) {
                String string3 = this.pagerTagExport.getPageOffset();
                if (string3 != null) {
                    this.oldOffset = servletRequest.getAttribute(string3);
                    servletRequest.setAttribute(string3, (Object)new Integer(this.offset));
                }
                if ((string3 = this.pagerTagExport.getPageNumber()) != null) {
                    this.oldPageNumber = servletRequest.getAttribute(string3);
                    servletRequest.setAttribute(string3, (Object)this.pageNumberInteger);
                }
            }
        } else if (this.pagerTagExport != null) {
            String string4 = this.pagerTagExport.getPageOffset();
            if (string4 != null) {
                this.oldOffset = this.pageContext.getAttribute(string4);
                this.pageContext.setAttribute(string4, (Object)new Integer(this.offset));
            }
            if ((string4 = this.pagerTagExport.getPageNumber()) != null) {
                this.oldPageNumber = this.pageContext.getAttribute(string4);
                this.pageContext.setAttribute(string4, (Object)this.pageNumberInteger);
            }
        }
        return 1;
    }

    private static final void restoreAttribute(ServletRequest servletRequest, String string, Object object) {
        if (object != null) {
            servletRequest.setAttribute(string, object);
        } else {
            servletRequest.removeAttribute(string);
        }
    }

    private static final void restoreAttribute(PageContext pageContext, String string, Object object) {
        if (object != null) {
            pageContext.setAttribute(string, object);
        } else {
            pageContext.removeAttribute(string);
        }
    }

    public final int doEndTag() throws JspException {
        if (REQUEST.equals(this.scope)) {
            ServletRequest servletRequest = this.pageContext.getRequest();
            PagerTag.restoreAttribute(servletRequest, this.id, this.oldPager);
            this.oldPager = null;
            if (this.pagerTagExport != null) {
                String string = this.pagerTagExport.getPageOffset();
                if (string != null) {
                    PagerTag.restoreAttribute(servletRequest, string, this.oldOffset);
                    this.oldOffset = null;
                }
                if ((string = this.pagerTagExport.getPageNumber()) != null) {
                    PagerTag.restoreAttribute(servletRequest, string, this.oldPageNumber);
                    this.oldPageNumber = null;
                }
            }
        } else if (this.pagerTagExport != null) {
            String string = this.pagerTagExport.getPageOffset();
            if (string != null) {
                PagerTag.restoreAttribute(this.pageContext, string, this.oldOffset);
                this.oldOffset = null;
            }
            if ((string = this.pagerTagExport.getPageNumber()) != null) {
                PagerTag.restoreAttribute(this.pageContext, string, this.oldPageNumber);
                this.oldPageNumber = null;
            }
        }
        if (this.uri.capacity() > 1024) {
            this.uri = null;
        }
        this.pageNumberInteger = null;
        return 6;
    }

    public final void release() {
        this.url = null;
        this.index = null;
        this.items = 0;
        this.maxItems = Integer.MAX_VALUE;
        this.maxPageItems = 10;
        this.maxIndexPages = 10;
        this.isOffset = false;
        this.export = null;
        this.scope = null;
        this.uri = null;
        this.params = 0;
        this.offset = 0;
        this.itemCount = 0;
        this.pageNumber = 0;
        this.pageNumberInteger = null;
        this.idOffsetParam = "pager.offset";
        this.pagerTagExport = null;
        this.oldPager = null;
        this.oldOffset = null;
        this.oldPageNumber = null;
        super.release();
    }

    private final /* synthetic */ void this() {
        this.url = null;
        this.index = null;
        this.items = 0;
        this.maxItems = Integer.MAX_VALUE;
        this.maxPageItems = 10;
        this.maxIndexPages = 10;
        this.isOffset = false;
        this.export = null;
        this.scope = null;
        this.uri = null;
        this.params = 0;
        this.offset = 0;
        this.itemCount = 0;
        this.pageNumber = 0;
        this.pageNumberInteger = null;
        this.idOffsetParam = "pager.offset";
        this.pagerTagExport = null;
        this.oldPager = null;
        this.oldOffset = null;
        this.oldPageNumber = null;
    }

    public PagerTag() {
        this.this();
        this.id = DEFAULT_ID;
    }
}

