/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.ezweb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.sourceforge.livez.CarrierType;
import jp.sourceforge.livez.Screen;
import jp.sourceforge.livez.ServiceType;
import jp.sourceforge.livez.dao.EZwebFrame;
import jp.sourceforge.livez.ezweb.EZappli;
import jp.sourceforge.livez.ezweb.EZappliImpl;
import jp.sourceforge.livez.ezweb.EZweb;
import jp.sourceforge.livez.ezweb.EZwebBrowser;
import jp.sourceforge.livez.ezweb.EZwebBrowserImpl;
import jp.sourceforge.livez.ezweb.EZwebMultiMedia;
import jp.sourceforge.livez.ezweb.EZwebRequest;
import jp.sourceforge.livez.ezweb.EZwebUserAgent;
import jp.sourceforge.livez.ezweb.Frame;
import jp.sourceforge.livez.ezweb.FrameImpl;
import jp.sourceforge.livez.ezweb.ScreenImpl;
import jp.sourceforge.livez.ezweb.Stamp;
import jp.sourceforge.livez.ezweb.StampImpl;
import jp.sourceforge.livez.ezweb.SubscriberId;
import jp.sourceforge.livez.images.ImageType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EZwebImpl
implements EZweb {
    private static final long serialVersionUID = 1L;
    private static final List<String> NON_PREMIUM_EZ = Arrays.asList("HI01", "HI02", "DN01", "TS11", "HI11", "CA11", "SY11", "SN11", "KC11", "MA11", "MA12", "HI12", "TS12", "CA12", "KC12");
    private CarrierType carrierType = null;
    private String id = null;
    private String productName = null;
    private String seriesName = null;
    private ScreenImpl screen = new ScreenImpl();
    private int softkeys = 0;
    private int softkeyLabelLength = 0;
    private EZwebBrowserImpl browser = null;
    private EZappliImpl appli = null;
    private List<Frame> frames = null;
    private Stamp stamp = null;
    private List<ImageType> imageTypes = new ArrayList<ImageType>(4);
    private EZwebMultiMedia dataFormat = null;
    private SubscriberId userId = null;
    private boolean premiumEZ = false;

    void setup(jp.sourceforge.livez.dao.EZweb ezweb) {
        this.id = ezweb.getDeviceType();
        this.productName = ezweb.getProductName();
        this.seriesName = ezweb.getSeriesName();
        this.screen.setup(ezweb);
        if (ezweb.getFrames() != null && ezweb.getFrames().size() > 0) {
            ArrayList<Frame> list = new ArrayList<Frame>(ezweb.getFrames().size());
            for (EZwebFrame frame : ezweb.getFrames()) {
                list.add(new FrameImpl(frame));
            }
            this.frames = list;
        }
        if (ezweb.getStamp() != null) {
            this.stamp = new StampImpl(ezweb.getStamp());
        }
        if (ezweb.isBmp1bit()) {
            this.imageTypes.add(ImageType.BMP_1BIT);
        }
        if (ezweb.isBmp2bit()) {
            this.imageTypes.add(ImageType.BMP_2BIT);
        }
        if (ezweb.isPng8bit()) {
            this.imageTypes.add(ImageType.PNG_8BIT);
        }
        if (ezweb.isJpeg()) {
            this.imageTypes.add(ImageType.JPEG);
        }
        if (ezweb.isGif()) {
            this.imageTypes.add(ImageType.GIF_8BIT);
        }
    }

    void setup(EZwebRequest r) {
        EZwebUserAgent ua = r.getUserAgent();
        EZwebMultiMedia media = r.getDataFormat();
        switch (ua.getId().charAt(2)) {
            case 'T': 
            case 'U': {
                this.carrierType = CarrierType.TUKA;
                break;
            }
            default: {
                this.carrierType = CarrierType.AU;
                this.premiumEZ = !NON_PREMIUM_EZ.contains(ua.getId());
            }
        }
        this.id = ua.getId();
        this.screen.setup(r);
        this.softkeys = r.getSoftkeys();
        this.softkeyLabelLength = r.getSoftkeyLabelLength();
        this.browser = new EZwebBrowserImpl(r);
        if (media.getJava() > 0 || media.getBrew() > 0) {
            this.appli = new EZappliImpl(media);
        }
        this.dataFormat = media;
        this.userId = r.getSubscriberID();
    }

    @Override
    public ServiceType getServiceType() {
        return ServiceType.EZWEB;
    }

    @Override
    public CarrierType getCarrierType() {
        return this.carrierType;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getSeriesName() {
        return this.seriesName;
    }

    @Override
    public String getVendorId() {
        return null;
    }

    @Override
    public Screen getScreen() {
        return this.screen;
    }

    @Override
    public int getSoftkeys() {
        return this.softkeys;
    }

    @Override
    public int getSoftkeyLabelLength() {
        return this.softkeyLabelLength;
    }

    @Override
    public EZwebBrowser getBrowser() {
        return this.browser;
    }

    @Override
    public EZappli getAppli() {
        return this.appli;
    }

    @Override
    public List<Frame> getFrames() {
        return this.frames;
    }

    @Override
    public Stamp getStamp() {
        return this.stamp;
    }

    @Override
    public List<ImageType> getEnableImageTypes() {
        return this.imageTypes;
    }

    @Override
    public EZwebMultiMedia getDataFormat() {
        return this.dataFormat;
    }

    @Override
    public SubscriberId getUserId() {
        return this.userId;
    }

    @Override
    public boolean isPremiumEZ() {
        return this.premiumEZ;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}

