/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.ezweb;

import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.livez.IllegalRequestException;
import jp.sourceforge.livez.ezweb.EZwebMultiMedia;
import jp.sourceforge.livez.ezweb.EZwebMultiMediaImpl;
import jp.sourceforge.livez.ezweb.EZwebRequest;
import jp.sourceforge.livez.ezweb.EZwebUserAgent;
import jp.sourceforge.livez.ezweb.EZwebUserAgentImpl;
import jp.sourceforge.livez.ezweb.SubscriberId;
import jp.sourceforge.livez.ezweb.SubscriberIdImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.NumberUtils;

final class EZwebRequestImpl
implements EZwebRequest {
    private EZwebUserAgent userAgent = null;
    private String EZServerName = null;
    private boolean titlebar = false;
    private boolean colorScreen = false;
    private int maxDataSize = 0;
    private int softkeys = 0;
    private int characterMaxLength = 0;
    private int characterMaxRow = 0;
    private int color = 0;
    private int browserWidth = 0;
    private int browserHeight = 0;
    private int softkeyLabelLength = 0;
    private SubscriberId subscriberId = null;
    private String sid = null;
    private EZwebMultiMedia dataFormat = null;
    private boolean cc = false;
    private boolean qvga = false;
    private boolean nonAttachment = false;

    public EZwebRequestImpl(HttpServletRequest request) throws IllegalRequestException {
        this.userAgent = new EZwebUserAgentImpl(request);
        this.EZServerName = request.getHeader("x-up-uplink");
        this.titlebar = "1".equals(request.getHeader("x-up-devcap-titlebar"));
        this.colorScreen = "1".equals(request.getHeader("x-up-devcap-iscolor"));
        this.maxDataSize = NumberUtils.toInt(request.getHeader("x-up-devcap-max-pdu"));
        this.softkeys = NumberUtils.toInt(request.getHeader("x-up-devcap-numsoftkeys"));
        String[] strings = EZwebRequestImpl.getTwoNumberProperty(request, "x-up-devcap-screenchars");
        if (strings != null) {
            this.characterMaxLength = NumberUtils.toInt(strings[0]);
            this.characterMaxRow = NumberUtils.toInt(strings[1]);
        }
        this.color = EZwebRequestImpl.getColor(request.getHeader("x-up-devcap-screendepth"));
        strings = EZwebRequestImpl.getTwoNumberProperty(request, "x-up-devcap-screenpixels");
        if (strings != null) {
            this.browserWidth = NumberUtils.toInt(strings[0]);
            this.browserHeight = NumberUtils.toInt(strings[1]);
        }
        this.softkeyLabelLength = NumberUtils.toInt(request.getHeader("x-up-devcap-softkeysize"));
        try {
            this.subscriberId = new SubscriberIdImpl(request);
        }
        catch (NullPointerException e) {
            this.subscriberId = null;
        }
        this.sid = request.getHeader("x-up-devcap-zone");
        try {
            this.dataFormat = new EZwebMultiMediaImpl(request);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalRequestException(e.getMessage(), e);
        }
        this.cc = "1".equals(request.getHeader("x-up-devcap-cc"));
        this.qvga = "1".equals(request.getHeader("x-up-devcap-qvga"));
        this.nonAttachment = "1".equals(request.getHeader("x-up-devcap-nonattachment"));
    }

    private static int getColor(String screendepth) {
        int depth = 0;
        String[] strings = StringUtils.defaultString(screendepth).split(",");
        String str = strings[0];
        if (str.equals("256")) {
            str = "8";
        }
        if (NumberUtils.isNumber(str)) {
            depth = NumberUtils.toInt(str);
        }
        return 2 ^ depth;
    }

    private static String[] getTwoNumberProperty(HttpServletRequest request, String propertyName) {
        String[] works;
        String[] ret = null;
        String str = request.getHeader(propertyName);
        if (StringUtils.isNotEmpty(str) && (works = str.split(",")).length == 2 && NumberUtils.isNumber(works[0]) && NumberUtils.isNumber(works[1])) {
            ret = works;
        }
        return ret;
    }

    public final EZwebUserAgent getUserAgent() {
        return this.userAgent;
    }

    public String getEZServerName() {
        return this.EZServerName;
    }

    public final boolean isTitlebar() {
        return this.titlebar;
    }

    public final boolean isColorScreen() {
        return this.colorScreen;
    }

    public final int getMaxDataSize() {
        return this.maxDataSize;
    }

    public final int getSoftkeys() {
        return this.softkeys;
    }

    public final int getCharacterColumn() {
        return this.characterMaxLength;
    }

    public final int getCharacterRow() {
        return this.characterMaxRow;
    }

    public final int getColor() {
        return this.color;
    }

    public final int getBrowserWidth() {
        return this.browserWidth;
    }

    public final int getBrowserHeight() {
        return this.browserHeight;
    }

    public final int getSoftkeyLabelLength() {
        return this.softkeyLabelLength;
    }

    public final SubscriberId getSubscriberID() {
        return this.subscriberId;
    }

    public String getSid() {
        return this.sid;
    }

    public EZwebMultiMedia getDataFormat() {
        return this.dataFormat;
    }

    public boolean isCc() {
        return this.cc;
    }

    public boolean isQvga() {
        return this.qvga;
    }

    public boolean isNonAttachment() {
        return this.nonAttachment;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}

