/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.ezweb;

import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.livez.IllegalUserAgentException;
import jp.sourceforge.livez.UserAgentNotFoundException;
import jp.sourceforge.livez.ezweb.EZwebUserAgent;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

final class EZwebUserAgentImpl
implements EZwebUserAgent {
    private static final String DEVICE_TYPE_PATTERN = "[A-Z]{2}[A-Z0-9]{2}";
    private static final String WAP_PATTERN = "^UP\\.Browser/.+-[A-Z]{2}[A-Z0-9]{2} .+/.+$";
    private static final String WAP2_PATTERN = "^KDDI-[A-Z]{2}[A-Z0-9]{2} UP\\.Browser/.+ \\(GUI\\) .+/.+$";
    private String value = null;
    private String id = null;
    private boolean wap2 = false;
    private String browserVersion = null;
    private String serverName = null;
    private String serverVersion = null;

    public EZwebUserAgentImpl(HttpServletRequest request) throws UserAgentNotFoundException, IllegalUserAgentException {
        this(request.getHeader("User-Agent"));
    }

    public EZwebUserAgentImpl(String ua) throws UserAgentNotFoundException, IllegalUserAgentException {
        if (ua == null) {
            throw new UserAgentNotFoundException();
        }
        if (!ua.matches(WAP_PATTERN) && !ua.matches(WAP2_PATTERN)) {
            throw new IllegalUserAgentException(ua);
        }
        this.value = ua;
        this.id = ua.substring(ua.indexOf(45) + 1, ua.indexOf(32));
        this.wap2 = !ua.startsWith("UP.Browser");
        int start = ua.indexOf(47);
        int end = !this.wap2 ? ua.indexOf(45, start + 1) : ua.indexOf(40, start + 1);
        this.browserVersion = ua.substring(start + 1, end);
        String[] s = ua.substring(ua.lastIndexOf(32) + 1).split("/");
        this.serverName = s[0];
        this.serverVersion = s[1];
    }

    public String getValue() {
        return this.value;
    }

    public String getId() {
        return this.id;
    }

    public boolean isWap2() {
        return this.wap2;
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}

