/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.ezweb;

import jp.sourceforge.livez.Screen;
import jp.sourceforge.livez.dao.EZweb;
import jp.sourceforge.livez.ezweb.EZwebRequest;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

final class ScreenImpl
implements Screen {
    private static final long serialVersionUID = 1L;
    private int width = 0;
    private int height = 0;
    private boolean monochrome = true;
    private int color = 2;
    private boolean qvga = false;

    void setup(EZweb ezweb) {
        if (ezweb.getScreenWidth() != null) {
            this.width = ezweb.getScreenWidth();
        }
        if (ezweb.getScreenHeight() != null) {
            this.height = ezweb.getScreenHeight();
        }
    }

    void setup(EZwebRequest r) {
        this.monochrome = !r.isColorScreen();
        this.color = r.getColor();
        this.qvga = r.getBrowserWidth() >= 200 && r.getBrowserHeight() >= 200 || "SN24".equals(r.getUserAgent().getId());
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isMonochrome() {
        return this.monochrome;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isQVGA() {
        return this.qvga;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}

