/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.sourceforge.livez.MobilePhoneFactory;
import jp.sourceforge.livez.ServiceNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class MobilePhoneFilter
implements Filter {
    private static final Log log = LogFactory.getLog(MobilePhoneFilter.class);
    private WebApplicationContext context;
    private String url;

    public void init(FilterConfig filterConfig) {
        this.context = WebApplicationContextUtils.getWebApplicationContext(filterConfig.getServletContext());
        this.url = filterConfig.getInitParameter("url");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            request.setAttribute("jp.sourceforge.livez.MobilePhone", (Object)MobilePhoneFactory.getMobilePhone((HttpServletRequest)request, this.context));
        }
        catch (ServiceNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug(e.getMessage(), e);
            }
            this.redirect(request, response);
            return;
        }
        if (response.isCommitted()) {
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        this.context = null;
        this.url = null;
    }

    private void redirect(ServletRequest request, ServletResponse response) throws IOException {
        HttpServletResponse res = (HttpServletResponse)response;
        if (this.url != null) {
            res.sendRedirect(this.url);
        } else {
            res.sendError(400);
        }
    }
}

