/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.images;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import jp.sourceforge.livez.images.ImageType;
import org.apache.commons.io.FilenameUtils;

public final class ImageConverter {
    private ImageConverter() {
    }

    public static void converte(String src, ImageType type) throws IllegalArgumentException, IOException {
        String dist = ImageConverter.getDistFilename(src, type);
        ImageConverter.converte(new File(src), new File(dist), type);
    }

    public static void converte(String src, ImageType type, double scale) throws IllegalArgumentException, IOException {
        String dist = ImageConverter.getDistFilename(src, type);
        ImageConverter.converte(new File(src), new File(dist), type, scale, scale);
    }

    public static void converte(String src, ImageType type, double sx, double sy) throws IllegalArgumentException, IOException {
        String dist = ImageConverter.getDistFilename(src, type);
        ImageConverter.converte(new File(src), new File(dist), type, sx, sy);
    }

    public static void converte(String src, ImageType type, int width, int height) throws IllegalArgumentException, IOException {
        String dist = ImageConverter.getDistFilename(src, type);
        ImageConverter.converte(new File(src), new File(dist), type, width, height);
    }

    private static String getDistFilename(String src, ImageType type) throws IllegalArgumentException {
        if (src == null || src.length() <= 0) {
            throw new IllegalArgumentException("src is null or blank.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null.");
        }
        return String.valueOf(FilenameUtils.getFullPath(src)) + FilenameUtils.getBaseName(src) + '.' + type.getSuffix();
    }

    public static void converte(String src, String dist, ImageType type) throws IllegalArgumentException, IOException {
        ImageConverter.converte(new File(src), new File(dist), type);
    }

    public static void converte(String src, String dist, ImageType type, double scale) throws IllegalArgumentException, IOException {
        ImageConverter.converte(new File(src), new File(dist), type, scale, scale);
    }

    public static void converte(String src, String dist, ImageType type, double sx, double sy) throws IllegalArgumentException, IOException {
        ImageConverter.converte(new File(src), new File(dist), type, sx, sy);
    }

    public static void converte(String src, String dist, ImageType type, int width, int height) throws IllegalArgumentException, IOException {
        ImageConverter.converte(new File(src), new File(dist), type, width, height);
    }

    public static void converte(File src, File dist, ImageType type) throws IllegalArgumentException, IOException {
        ImageConverter.converte(src, dist, type, -1, -1);
    }

    public static void converte(File src, File dist, ImageType type, double scale) throws IllegalArgumentException, IOException {
        ImageConverter.converte(src, dist, type, scale, scale);
    }

    public static void converte(File src, File dist, ImageType type, double sx, double sy) throws IllegalArgumentException, IOException {
        BufferedImage in = ImageIO.read(src);
        BufferedImage out = ImageConverter.converteBufferedImage(in, type, sx, sy);
        ImageIO.write((RenderedImage)out, type.getFormatName(), dist);
    }

    public static void converte(File src, File dist, ImageType type, int width, int height) throws IllegalArgumentException, IOException {
        BufferedImage in = ImageIO.read(src);
        BufferedImage out = ImageConverter.converteBufferedImage(in, type, width > 0 ? width : in.getWidth(), height > 0 ? height : in.getHeight());
        ImageIO.write((RenderedImage)out, type.getFormatName(), dist);
    }

    public static BufferedImage converteBufferedImage(BufferedImage source, ImageType type) throws IllegalArgumentException {
        return ImageConverter.converteBufferedImage(source, type, source.getWidth(), source.getHeight());
    }

    public static BufferedImage converteBufferedImage(BufferedImage source, ImageType type, double scale) throws IllegalArgumentException {
        return ImageConverter.converteBufferedImage(source, type, (int)((double)source.getWidth() * scale), (int)((double)source.getHeight() * scale));
    }

    public static BufferedImage converteBufferedImage(BufferedImage source, ImageType type, double sx, double sy) throws IllegalArgumentException {
        return ImageConverter.converteBufferedImage(source, type, (int)((double)source.getWidth() * sx), (int)((double)source.getHeight() * sy));
    }

    public static BufferedImage converteBufferedImage(BufferedImage source, ImageType type, int width, int height) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        AreaAveragingScaleFilter filter = new AreaAveragingScaleFilter(width, height);
        Image image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(source.getSource(), filter));
        int t = type.getBufferedImageType() == -1 ? source.getType() : type.getBufferedImageType();
        IndexColorModel indexColorModel = type.getIndexColorModel();
        BufferedImage result = indexColorModel == null ? new BufferedImage(width, height, t) : new BufferedImage(width, height, t, indexColorModel);
        result.createGraphics().drawImage(image, 0, 0, null);
        return result;
    }
}

