/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.imode;

import java.io.IOException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.sourceforge.livez.IllegalRequestException;
import jp.sourceforge.livez.imode.MyMenuRequest;
import jp.sourceforge.livez.imode.MyMenuRequestImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMyMenuAction {
    protected static final Log log = LogFactory.getLog(AbstractMyMenuAction.class);

    public final void execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            throw new IllegalRequestException(request.getMethod());
        }
        String action = request.getParameter("act");
        MyMenuRequestImpl req = new MyMenuRequestImpl(request);
        boolean success = false;
        if ("reg".equals(action)) {
            try {
                success = this.register(req);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error(e.getMessage(), e);
                }
            }
        } else if ("rel".equals(action)) {
            try {
                success = this.release(req);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error(e.getMessage(), e);
                }
            }
        } else {
            throw new IllegalRequestException(action);
        }
        AbstractMyMenuAction.write((ServletResponse)response, success);
    }

    private static void write(ServletResponse response, boolean success) throws IOException {
        response.setContentType("text/html");
        response.setContentLength(3);
        response.getWriter().print(success ? "OK\n" : "NG\n");
    }

    protected abstract boolean register(MyMenuRequest var1) throws Exception;

    protected abstract boolean release(MyMenuRequest var1) throws Exception;
}

