/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.imode;

import jp.sourceforge.livez.dao.Imode;
import jp.sourceforge.livez.imode.ImodeBrowser;
import jp.sourceforge.livez.imode.ImodeUserAgent;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

final class ImodeBrowserImpl
implements ImodeBrowser {
    private static final long serialVersionUID = 1L;
    private int width = 0;
    private int height = 0;
    private int column = 0;
    private int row = 0;
    private int cacheSize = 0;
    private float htmlVersion;
    private Float xhtmlVersion = null;

    void setup(Imode imode) {
        this.width = imode.getBrowserWidth();
        this.height = imode.getBrowserHeight();
        if (imode.getBrowserColumn() != null) {
            this.column = imode.getBrowserColumn();
        }
        if (imode.getBrowserRow() != null) {
            this.row = imode.getBrowserRow();
        }
        this.htmlVersion = imode.getHtml().floatValue();
        if (imode.getXhtml() != null) {
            this.xhtmlVersion = imode.getXhtml();
        }
    }

    void setup(ImodeUserAgent ua) {
        if (ua.getWidth() > 0) {
            this.column = ua.getWidth();
        }
        if (ua.getHeight() > 0) {
            this.row = ua.getHeight();
        }
        this.cacheSize = ua.getCacheSize() * 1024;
        if (ua.getHtmlVersion() != null) {
            this.htmlVersion = ua.getHtmlVersion().floatValue();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public float getHtmlVersion() {
        return this.htmlVersion;
    }

    public Float getXhtmlVersion() {
        return this.xhtmlVersion;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}

