/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.imode;

import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.livez.IllegalRequestException;
import jp.sourceforge.livez.imode.ImodeRequest;
import jp.sourceforge.livez.imode.ImodeUserAgent;
import jp.sourceforge.livez.imode.ImodeUserAgentImpl;
import jp.sourceforge.livez.imode.UID;
import jp.sourceforge.livez.imode.UIDImpl;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

final class ImodeRequestImpl
implements ImodeRequest {
    private ImodeUserAgent userAgent = null;
    private UID uid = null;
    private int roaming = -1;

    public ImodeRequestImpl(String ua) throws IllegalRequestException {
        this(ua, null, -1);
    }

    public ImodeRequestImpl(String ua, String uid) throws IllegalRequestException {
        this(ua, uid, -1);
    }

    public ImodeRequestImpl(String ua, String uid, int dcmroaming) throws IllegalRequestException {
        this.userAgent = new ImodeUserAgentImpl(ua);
        this.roaming = dcmroaming;
        if (uid != null) {
            this.uid = new UIDImpl(uid);
        }
    }

    public ImodeRequestImpl(HttpServletRequest request) throws IllegalRequestException {
        this.userAgent = new ImodeUserAgentImpl(request);
        try {
            this.uid = new UIDImpl(request);
        }
        catch (NullPointerException e) {
            this.uid = null;
        }
        try {
            this.roaming = request.getIntHeader("X-DCMRoaming");
        }
        catch (NumberFormatException e) {
            throw new IllegalRequestException(e.getMessage(), e);
        }
    }

    public ImodeUserAgent getUserAgent() {
        return this.userAgent;
    }

    public UID getUID() {
        return this.uid;
    }

    public int getRoaming() {
        return this.roaming;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}

