/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.imode;

import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.livez.IllegalUserIdException;
import jp.sourceforge.livez.imode.UID;
import jp.sourceforge.livez.imode.UIDType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

final class UIDImpl
implements UID {
    private static final long serialVersionUID = 1L;
    private String value = null;
    private UIDType type = null;
    private String userId = null;
    private boolean member = false;

    public UIDImpl(String uid) throws NullPointerException, IllegalUserIdException {
        this.parse(uid);
    }

    public UIDImpl(HttpServletRequest request) throws NullPointerException, IllegalUserIdException {
        this.parse(request.getParameter("uid"));
    }

    private void parse(String uid) throws NullPointerException, IllegalUserIdException {
        if (uid.matches("^(00|01){1}[0-9a-zA-Z]{10}$")) {
            this.value = uid;
            this.member = true;
            try {
                this.type = UIDType.getUIDType(uid.substring(0, 2));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalUserIdException(e.getMessage(), e);
            }
            this.userId = uid.substring(2);
        } else if ("NULLGWDOCOMO".equals(uid)) {
            this.value = uid;
        } else {
            throw new IllegalUserIdException(uid);
        }
    }

    public String getValue() {
        return this.value;
    }

    public UIDType getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isMember() {
        return this.member;
    }

    public boolean isGuest() {
        return !this.member;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}

