/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.lang;

import java.io.UnsupportedEncodingException;
import jp.sourceforge.livez.lang.Ascii;
import org.apache.commons.lang.StringUtils;

public final class JaStringUtils {
    public static final char WIDE_SPACE = '\u3000';
    private static final String NARROW_DIGIT = "0123456789";
    private static final String WIDE_DIGIT = "\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19";
    private static final String NARROW_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String WIDE_ALPHABET = "\uff21\uff22\uff23\uff24\uff25\uff26\uff27\uff28\uff29\uff2a\uff2b\uff2c\uff2d\uff2e\uff2f\uff30\uff31\uff32\uff33\uff34\uff35\uff36\uff37\uff38\uff39\uff3a\uff41\uff42\uff43\uff44\uff45\uff46\uff47\uff48\uff49\uff4a\uff4b\uff4c\uff4d\uff4e\uff4f\uff50\uff51\uff52\uff53\uff54\uff55\uff56\uff57\uff58\uff59\uff5a";
    private static final String NARROW_ASCII = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz !\"#$%&'(*+,-./:;<=>?@[\\]^_`{|}";
    private static final String WIDE_ASCII = "\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19\uff21\uff22\uff23\uff24\uff25\uff26\uff27\uff28\uff29\uff2a\uff2b\uff2c\uff2d\uff2e\uff2f\uff30\uff31\uff32\uff33\uff34\uff35\uff36\uff37\uff38\uff39\uff3a\uff41\uff42\uff43\uff44\uff45\uff46\uff47\uff48\uff49\uff4a\uff4b\uff4c\uff4d\uff4e\uff4f\uff50\uff51\uff52\uff53\uff54\uff55\uff56\uff57\uff58\uff59\uff5a\u3000\uff01\u201d\uff03\uff04\uff05\uff06\u2019\uff08\uff0a\uff0b\uff0c\uff0d\uff0e\uff0f\uff1a\uff1b\uff1c\uff1d\uff1e\uff1f\uff20\uff3b\uffe5\uff3d\uff3e\uff3f\uff40\uff5b\uff5c\uff5d";
    private static final String[] HIRAGANA;
    private static final String[] WIDE_KATAKANA;
    private static final String[] NARROW_KATAKANA;

    static {
        String[] stringArray = new String[116];
        stringArray[0] = "\u304c";
        stringArray[1] = "\u304e";
        stringArray[2] = "\u3050";
        stringArray[3] = "\u3052";
        stringArray[4] = "\u3054";
        stringArray[5] = "\u3056";
        stringArray[6] = "\u3058";
        stringArray[7] = "\u305a";
        stringArray[8] = "\u305c";
        stringArray[9] = "\u305e";
        stringArray[10] = "\u3060";
        stringArray[11] = "\u3062";
        stringArray[12] = "\u3065";
        stringArray[13] = "\u3067";
        stringArray[14] = "\u3069";
        stringArray[15] = "\u3070";
        stringArray[16] = "\u3073";
        stringArray[17] = "\u3076";
        stringArray[18] = "\u3079";
        stringArray[19] = "\u307c";
        stringArray[20] = "\u3071";
        stringArray[21] = "\u3074";
        stringArray[22] = "\u3077";
        stringArray[23] = "\u307a";
        stringArray[24] = "\u307d";
        stringArray[30] = "\u3042";
        stringArray[31] = "\u3044";
        stringArray[32] = "\u3046";
        stringArray[33] = "\u3048";
        stringArray[34] = "\u304a";
        stringArray[35] = "\u304b";
        stringArray[36] = "\u304d";
        stringArray[37] = "\u304f";
        stringArray[38] = "\u3051";
        stringArray[39] = "\u3053";
        stringArray[40] = "\u3055";
        stringArray[41] = "\u3057";
        stringArray[42] = "\u3059";
        stringArray[43] = "\u305b";
        stringArray[44] = "\u305d";
        stringArray[45] = "\u305f";
        stringArray[46] = "\u3061";
        stringArray[47] = "\u3064";
        stringArray[48] = "\u3066";
        stringArray[49] = "\u3068";
        stringArray[50] = "\u306a";
        stringArray[51] = "\u306b";
        stringArray[52] = "\u306c";
        stringArray[53] = "\u306d";
        stringArray[54] = "\u306e";
        stringArray[55] = "\u306f";
        stringArray[56] = "\u3072";
        stringArray[57] = "\u3075";
        stringArray[58] = "\u3078";
        stringArray[59] = "\u307b";
        stringArray[60] = "\u307e";
        stringArray[61] = "\u307f";
        stringArray[62] = "\u3080";
        stringArray[63] = "\u3081";
        stringArray[64] = "\u3082";
        stringArray[65] = "\u3084";
        stringArray[66] = "\u3086";
        stringArray[67] = "\u3088";
        stringArray[68] = "\u3089";
        stringArray[69] = "\u308a";
        stringArray[70] = "\u308b";
        stringArray[71] = "\u308c";
        stringArray[72] = "\u308d";
        stringArray[73] = "\u308f";
        stringArray[74] = "\u3090";
        stringArray[75] = "\u3091";
        stringArray[76] = "\u3092";
        stringArray[77] = "\u3093";
        stringArray[78] = "\u3041";
        stringArray[79] = "\u3043";
        stringArray[80] = "\u3045";
        stringArray[81] = "\u3047";
        stringArray[82] = "\u3049";
        stringArray[83] = "\u3095";
        stringArray[85] = "\u3096";
        stringArray[88] = "\u3063";
        stringArray[97] = "\u3083";
        stringArray[98] = "\u3085";
        stringArray[99] = "\u3087";
        stringArray[105] = "\u308e";
        stringArray[106] = "\u309b";
        stringArray[107] = "\u309c";
        stringArray[108] = "\u30fb";
        stringArray[109] = "\u30fc";
        stringArray[110] = "\u309d";
        stringArray[111] = "\u309e";
        stringArray[112] = "\u3002";
        stringArray[113] = "\u300c";
        stringArray[114] = "\u300d";
        stringArray[115] = "\u3001";
        HIRAGANA = stringArray;
        WIDE_KATAKANA = new String[]{"\u30ac", "\u30ae", "\u30b0", "\u30b2", "\u30b4", "\u30b6", "\u30b8", "\u30ba", "\u30bc", "\u30be", "\u30c0", "\u30c2", "\u30c5", "\u30c7", "\u30c9", "\u30d0", "\u30d3", "\u30d6", "\u30d9", "\u30dc", "\u30d1", "\u30d4", "\u30d7", "\u30da", "\u30dd", "\u30f7", "\u30f8", "\u30f4", "\u30f9", "\u30fa", "\u30a2", "\u30a4", "\u30a6", "\u30a8", "\u30aa", "\u30ab", "\u30ad", "\u30af", "\u30b1", "\u30b3", "\u30b5", "\u30b7", "\u30b9", "\u30bb", "\u30bd", "\u30bf", "\u30c1", "\u30c4", "\u30c6", "\u30c8", "\u30ca", "\u30cb", "\u30cc", "\u30cd", "\u30ce", "\u30cf", "\u30d2", "\u30d5", "\u30d8", "\u30db", "\u30de", "\u30df", "\u30e0", "\u30e1", "\u30e2", "\u30e4", "\u30e6", "\u30e8", "\u30e9", "\u30ea", "\u30eb", "\u30ec", "\u30ed", "\u30ef", "\u30f0", "\u30f1", "\u30f2", "\u30f3", "\u30a1", "\u30a3", "\u30a5", "\u30a7", "\u30a9", "\u30f5", "\u31f0", "\u30f6", "\u31f1", "\u31f2", "\u30c3", "\u31f3", "\u31f4", "\u31f5", "\u31f6", "\u31f7", "\u31f8", "\u31f9", "\u31fa", "\u30e3", "\u30e5", "\u30e7", "\u31fb", "\u31fc", "\u31fd", "\u31fe", "\u31ff", "\u30ee", "\u309b", "\u309c", "\u30fb", "\u30fc", "\u30fd", "\u30fe", "\u3002", "\u300c", "\u300d", "\u3001"};
        String[] stringArray2 = new String[116];
        stringArray2[0] = "\uff76\uff9e";
        stringArray2[1] = "\uff77\uff9e";
        stringArray2[2] = "\uff78\uff9e";
        stringArray2[3] = "\uff79\uff9e";
        stringArray2[4] = "\uff7a\uff9e";
        stringArray2[5] = "\uff7b\uff9e";
        stringArray2[6] = "\uff7c\uff9e";
        stringArray2[7] = "\uff7d\uff9e";
        stringArray2[8] = "\uff7e\uff9e";
        stringArray2[9] = "\uff7f\uff9e";
        stringArray2[10] = "\uff80\uff9e";
        stringArray2[11] = "\uff81\uff9e";
        stringArray2[12] = "\uff82\uff9e";
        stringArray2[13] = "\uff83\uff9e";
        stringArray2[14] = "\uff84\uff9e";
        stringArray2[15] = "\uff8a\uff9e";
        stringArray2[16] = "\uff8b\uff9e";
        stringArray2[17] = "\uff8c\uff9e";
        stringArray2[18] = "\uff8d\uff9e";
        stringArray2[19] = "\uff8e\uff9e";
        stringArray2[20] = "\uff8a\uff9f";
        stringArray2[21] = "\uff8b\uff9f";
        stringArray2[22] = "\uff8c\uff9f";
        stringArray2[23] = "\uff8d\uff9f";
        stringArray2[24] = "\uff8e\uff9f";
        stringArray2[25] = "\uff9c\uff9e";
        stringArray2[27] = "\uff73\uff9e";
        stringArray2[29] = "\uff66\uff9e";
        stringArray2[30] = "\uff71";
        stringArray2[31] = "\uff72";
        stringArray2[32] = "\uff73";
        stringArray2[33] = "\uff74";
        stringArray2[34] = "\uff75";
        stringArray2[35] = "\uff76";
        stringArray2[36] = "\uff77";
        stringArray2[37] = "\uff78";
        stringArray2[38] = "\uff79";
        stringArray2[39] = "\uff7a";
        stringArray2[40] = "\uff7b";
        stringArray2[41] = "\uff7c";
        stringArray2[42] = "\uff7d";
        stringArray2[43] = "\uff7e";
        stringArray2[44] = "\uff7f";
        stringArray2[45] = "\uff80";
        stringArray2[46] = "\uff81";
        stringArray2[47] = "\uff82";
        stringArray2[48] = "\uff83";
        stringArray2[49] = "\uff84";
        stringArray2[50] = "\uff85";
        stringArray2[51] = "\uff86";
        stringArray2[52] = "\uff87";
        stringArray2[53] = "\uff88";
        stringArray2[54] = "\uff89";
        stringArray2[55] = "\uff8a";
        stringArray2[56] = "\uff8b";
        stringArray2[57] = "\uff8c";
        stringArray2[58] = "\uff8d";
        stringArray2[59] = "\uff8e";
        stringArray2[60] = "\uff8f";
        stringArray2[61] = "\uff90";
        stringArray2[62] = "\uff91";
        stringArray2[63] = "\uff92";
        stringArray2[64] = "\uff93";
        stringArray2[65] = "\uff94";
        stringArray2[66] = "\uff95";
        stringArray2[67] = "\uff96";
        stringArray2[68] = "\uff97";
        stringArray2[69] = "\uff98";
        stringArray2[70] = "\uff99";
        stringArray2[71] = "\uff9a";
        stringArray2[72] = "\uff9b";
        stringArray2[73] = "\uff9c";
        stringArray2[76] = "\uff66";
        stringArray2[77] = "\uff9d";
        stringArray2[78] = "\uff67";
        stringArray2[79] = "\uff68";
        stringArray2[80] = "\uff69";
        stringArray2[81] = "\uff6a";
        stringArray2[82] = "\uff6b";
        stringArray2[88] = "\uff6f";
        stringArray2[97] = "\uff6c";
        stringArray2[98] = "\uff6d";
        stringArray2[99] = "\uff6e";
        stringArray2[106] = "\uff9e";
        stringArray2[107] = "\uff9f";
        stringArray2[108] = "\uff65";
        stringArray2[109] = "\uff70";
        stringArray2[112] = "\uff61";
        stringArray2[113] = "\uff62";
        stringArray2[114] = "\uff63";
        stringArray2[115] = "\uff64";
        NARROW_KATAKANA = stringArray2;
    }

    private JaStringUtils() {
    }

    public static boolean isHiragana(String s) {
        return JaStringUtils.validate(s, '\u3040', '\u309f');
    }

    public static boolean isKatakana(String s) {
        return JaStringUtils.validate(s, '\u30a0', '\u30ff');
    }

    public static boolean isKatakanaPhoneticExtensions(String s) {
        return JaStringUtils.validate(s, '\u31f0', '\u31ff');
    }

    public static boolean isHalfwidthCJKPunctuation(String s) {
        return JaStringUtils.validate(s, '\uff61', '\uff64');
    }

    public static boolean isHalfwidthKatakana(String s) {
        return JaStringUtils.validate(s, '\uff65', '\uff9f');
    }

    public static boolean isCJKUnifiedIdeographs(String s) {
        return JaStringUtils.validate(s, '\u4e00', '\u9fff');
    }

    private static boolean validate(String s, char start, char end) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c < start || c > end) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String microsoftUnicodeToUnicode(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\uff0d') {
                result.append('\u2212');
            } else if (c == '\uff5e') {
                result.append('\u301c');
            } else if (c == '\uffe0') {
                result.append('\u00a2');
            } else if (c == '\u2225') {
                result.append('\u2016');
            } else if (c == '\uffe1') {
                result.append('\u00a3');
            } else if (c == '\uffe2') {
                result.append('\u00ac');
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static String unicodeToMicrosoftUnicode(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\u2212') {
                result.append('\uff0d');
            } else if (c == '\u301c') {
                result.append('\uff5e');
            } else if (c == '\u00a2') {
                result.append('\uffe0');
            } else if (c == '\u2016') {
                result.append('\u2225');
            } else if (c == '\u00a3') {
                result.append('\uffe1');
            } else if (c == '\u00ac') {
                result.append('\uffe2');
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static int getShiftJISByteLength(String s) {
        if (s == null) {
            return 0;
        }
        try {
            return s.getBytes("Windows-31J").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static int getShiftJISByteLength(char c) {
        return JaStringUtils.getShiftJISByteLength(String.valueOf(c));
    }

    private static boolean isTrimCharacter(char c) {
        return Ascii.isControlCharacter(c) || c == ' ' || c == '\u3000';
    }

    public static String leftTrim(String s) {
        if (s == null) {
            return null;
        }
        int i = 0;
        while (i < s.length()) {
            if (!JaStringUtils.isTrimCharacter(s.charAt(i))) {
                return s.substring(i);
            }
            ++i;
        }
        return "";
    }

    public static String rightTrim(String s) {
        if (s == null) {
            return null;
        }
        int i = s.length() - 1;
        while (i >= 0) {
            if (!JaStringUtils.isTrimCharacter(s.charAt(i))) {
                return s.substring(0, i + 1);
            }
            --i;
        }
        return "";
    }

    public static String trim(String s) {
        return JaStringUtils.rightTrim(JaStringUtils.leftTrim(s));
    }

    public static String left(String s, int len) {
        if (s == null) {
            return null;
        }
        StringBuilder results = new StringBuilder(len);
        int count = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            int n = count + JaStringUtils.getShiftJISByteLength(c);
            if (n > len) break;
            int nextIndex = i + 1;
            if (n == len && nextIndex < s.length()) {
                char next = s.charAt(nextIndex);
                if (c == '\r' && next == '\n' || next == '\uff9e' || next == '\uff9f') break;
            }
            results.append(c);
            count = n;
            ++i;
        }
        return results.toString();
    }

    public static String right(String s, int len) {
        if (s == null) {
            return null;
        }
        StringBuilder results = new StringBuilder(len);
        int count = 0;
        int i = s.length() - 1;
        while (i >= 0) {
            char c = s.charAt(i);
            int n = count + JaStringUtils.getShiftJISByteLength(c);
            if (n > len) break;
            int j = i - 1;
            if (n == len && j < s.length()) {
                char next = s.charAt(j);
                if (c == '\n' && next == '\r' || c == '\uff9e' || c == '\uff9f') break;
            }
            results.append(c);
            count = n;
            --i;
        }
        return results.toString();
    }

    public static String toWideDigit(String s) {
        return JaStringUtils.convert(s, NARROW_DIGIT, WIDE_DIGIT);
    }

    public static String toNarrowDigit(String s) {
        return JaStringUtils.convert(s, WIDE_DIGIT, NARROW_DIGIT);
    }

    public static String toWideAlphabet(String s) {
        return JaStringUtils.convert(s, NARROW_ALPHABET, WIDE_ALPHABET);
    }

    public static String toNarrowAlphabet(String s) {
        return JaStringUtils.convert(s, WIDE_ALPHABET, NARROW_ALPHABET);
    }

    public static String toWideAscii(String s) {
        return JaStringUtils.convert(s, NARROW_ASCII, WIDE_ASCII);
    }

    public static String toNarrowAscii(String s) {
        return JaStringUtils.convert(s, WIDE_ASCII, NARROW_ASCII);
    }

    private static String convert(String s, String from, String to) {
        if (s == null) {
            return null;
        }
        StringBuilder results = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            int n = from.indexOf(c);
            if (n != -1) {
                results.append(to.charAt(n));
            } else {
                results.append(c);
            }
            ++i;
        }
        return results.toString();
    }

    public static String hiraganaToNarrowKana(String s) {
        return JaStringUtils.convert(s, HIRAGANA, NARROW_KATAKANA);
    }

    public static String hiraganaToWideKana(String s) {
        return JaStringUtils.convert(s, HIRAGANA, WIDE_KATAKANA);
    }

    public static String narrowKanaToWideKana(String s) {
        return JaStringUtils.convert(s, NARROW_KATAKANA, WIDE_KATAKANA);
    }

    public static String narrowKanaToHiragana(String s) {
        return JaStringUtils.convert(s, NARROW_KATAKANA, HIRAGANA);
    }

    public static String wideKanaToNarrowKana(String s) {
        return JaStringUtils.convert(s, WIDE_KATAKANA, NARROW_KATAKANA);
    }

    public static String wideKanaToHiragana(String s) {
        return JaStringUtils.convert(s, WIDE_KATAKANA, HIRAGANA);
    }

    public static String katakanaToHiragana(String s) {
        String result = s;
        result = JaStringUtils.narrowKanaToHiragana(result);
        result = JaStringUtils.wideKanaToHiragana(result);
        return result;
    }

    private static String convert(String s, String[] from, String[] to) {
        if (s == null) {
            return null;
        }
        String result = s;
        int i = 0;
        while (i < from.length) {
            if (from[i] != null && to[i] != null) {
                result = StringUtils.replace(result, from[i], to[i]);
            }
            ++i;
        }
        return result;
    }

    public static String toWide(String s) {
        return JaStringUtils.narrowKanaToWideKana(JaStringUtils.toWideAscii(s));
    }

    public static String toNarrow(String s) {
        return JaStringUtils.wideKanaToNarrowKana(JaStringUtils.toNarrowAscii(s));
    }
}

