/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.lang;

public final class VodafoneEmojiUtils {
    private static final int GI = 1;
    private static final int G1I = 2;
    private static final int G2I = 3;
    private static final int G3I = 4;
    private static final int G4I = 5;
    private static final int G5I = 6;
    private static final char ESC = '\u001b';
    private static final char SI = '\u000f';

    private VodafoneEmojiUtils() {
    }

    public static boolean isEmoji(char c) {
        return c >= '\ue001' && c <= '\ue05a' || c >= '\ue101' && c <= '\ue15a' || c >= '\ue201' && c <= '\ue25a' || c >= '\ue301' && c <= '\ue34d' || c >= '\ue401' && c <= '\ue44c' || c >= '\ue501' && c <= '\ue539';
    }

    public static String removeEmoji(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!VodafoneEmojiUtils.isEmoji(c)) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static String escapeWebCode123(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(s.length());
        int mode = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c >= '\ue001' && c <= '\ue05a') {
                if (mode != 1) {
                    if (mode != 0) {
                        result.append('\u000f');
                    }
                    mode = 1;
                    result.append(VodafoneEmojiUtils.renderShiftIn(mode));
                }
                result.append((char)(c - 57312));
            } else if (c >= '\ue101' && c <= '\ue15a') {
                if (mode != 2) {
                    if (mode != 0) {
                        result.append('\u000f');
                    }
                    mode = 2;
                    result.append(VodafoneEmojiUtils.renderShiftIn(mode));
                }
                result.append((char)(c - 57568));
            } else if (c >= '\ue201' && c <= '\ue25a') {
                if (mode != 3) {
                    if (mode != 0) {
                        result.append('\u000f');
                    }
                    mode = 3;
                    result.append(VodafoneEmojiUtils.renderShiftIn(mode));
                }
                result.append((char)(c - 57824));
            } else {
                if (mode != 0) {
                    result.append('\u000f');
                }
                mode = 0;
                result.append(c);
            }
            ++i;
        }
        if (mode != 0) {
            result.append('\u000f');
        }
        return result.toString();
    }

    public static String escapeWebCode456(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(s.length());
        int mode = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c >= '\ue301' && c <= '\ue34d') {
                if (mode != 4) {
                    if (mode != 0) {
                        result.append('\u000f');
                    }
                    mode = 4;
                    result.append(VodafoneEmojiUtils.renderShiftIn(mode));
                }
                result.append((char)(c - 58080));
            } else if (c >= '\ue401' && c <= '\ue44c') {
                if (mode != 5) {
                    if (mode != 0) {
                        result.append('\u000f');
                    }
                    mode = 5;
                    result.append(VodafoneEmojiUtils.renderShiftIn(mode));
                }
                result.append((char)(c - 58336));
            } else if (c >= '\ue501' && c <= '\ue539') {
                if (mode != 6) {
                    if (mode != 0) {
                        result.append('\u000f');
                    }
                    mode = 6;
                    result.append(VodafoneEmojiUtils.renderShiftIn(mode));
                }
                result.append((char)(c - 58592));
            } else {
                if (mode != 0) {
                    result.append('\u000f');
                }
                mode = 0;
                result.append(c);
            }
            ++i;
        }
        if (mode != 0) {
            result.append('\u000f');
        }
        return result.toString();
    }

    public static String escapeWebCode(String s) {
        return VodafoneEmojiUtils.escapeWebCode456(VodafoneEmojiUtils.escapeWebCode123(s));
    }

    public static String unescapeWebCode(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(s.length());
        int mode = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\u001b' && i + 1 < s.length()) {
                char c2 = s.charAt(i + 1);
                if (c2 == '$' && i + 2 < s.length()) {
                    boolean b;
                    char c3 = s.charAt(i + 2);
                    boolean bl = b = i + 3 < s.length();
                    if (c3 == 'G' && b) {
                        result.append((char)(s.charAt(i + 3) + 57312));
                        i += 4;
                        mode = 1;
                        continue;
                    }
                    if (c3 == 'E' && b) {
                        result.append((char)(s.charAt(i + 3) + 57568));
                        i += 4;
                        mode = 2;
                        continue;
                    }
                    if (c3 == 'F' && b) {
                        result.append((char)(s.charAt(i + 3) + 57824));
                        i += 4;
                        mode = 3;
                        continue;
                    }
                    if (c3 == 'O' && b) {
                        result.append((char)(s.charAt(i + 3) + 58080));
                        i += 4;
                        mode = 4;
                        continue;
                    }
                    if (c3 == 'P' && b) {
                        result.append((char)(s.charAt(i + 3) + 58336));
                        i += 4;
                        mode = 5;
                        continue;
                    }
                    if (c3 == 'Q' && b) {
                        result.append((char)(s.charAt(i + 3) + 58592));
                        i += 4;
                        mode = 6;
                        continue;
                    }
                    result.append(c);
                    result.append(c2);
                    result.append(c3);
                    i += 3;
                    mode = 0;
                    continue;
                }
                result.append(c);
                result.append(c2);
                i += 2;
                mode = 0;
                continue;
            }
            if ((mode == 1 || mode == 2 || mode == 3 || mode == 4 || mode == 5 || mode == 6) && c == '\u000f') {
                ++i;
                mode = 0;
                continue;
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    private static String renderShiftIn(int mode) {
        StringBuilder result = new StringBuilder(3);
        switch (mode) {
            case 1: {
                result.append('\u001b');
                result.append('$');
                result.append('G');
                break;
            }
            case 2: {
                result.append('\u001b');
                result.append('$');
                result.append('E');
                break;
            }
            case 3: {
                result.append('\u001b');
                result.append('$');
                result.append('F');
                break;
            }
            case 4: {
                result.append('\u001b');
                result.append('$');
                result.append('O');
                break;
            }
            case 5: {
                result.append('\u001b');
                result.append('$');
                result.append('P');
                break;
            }
            case 6: {
                result.append('\u001b');
                result.append('$');
                result.append('Q');
            }
        }
        return result.toString();
    }
}

