/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.vodafone;

import jp.sourceforge.livez.Screen;
import jp.sourceforge.livez.vodafone.VodafoneCategoryType;
import jp.sourceforge.livez.vodafone.VodafoneRequest;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

final class ScreenImpl
implements Screen {
    private static final long serialVersionUID = 1L;
    private int width;
    private int height;
    private boolean monochrome;
    private int color;
    private boolean qvga;

    public ScreenImpl(VodafoneRequest r) {
        if (r.getType().getCategoryType() == VodafoneCategoryType.THREE_GC) {
            this.width = r.getDisplayWidth();
            this.height = r.getDisplayHeight();
        } else {
            this.width = 0;
            this.height = 0;
        }
        this.qvga = this.width >= 240;
        this.monochrome = r.isMonochrome();
        this.color = r.getColor();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isMonochrome() {
        return this.monochrome;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isQVGA() {
        return this.qvga;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}

