/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.vodafone;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.livez.IllegalRequestException;
import jp.sourceforge.livez.vodafone.UID;
import jp.sourceforge.livez.vodafone.UIDImpl;
import jp.sourceforge.livez.vodafone.VodafoneCategoryType;
import jp.sourceforge.livez.vodafone.VodafoneRequest;
import jp.sourceforge.livez.vodafone.VodafoneSmaf;
import jp.sourceforge.livez.vodafone.VodafoneSmafImpl;
import jp.sourceforge.livez.vodafone.VodafoneType;
import jp.sourceforge.livez.vodafone.VodafoneUserAgent;
import jp.sourceforge.livez.vodafone.VodafoneUserAgentImpl;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.NumberUtils;

final class VodafoneRequestImpl
implements VodafoneRequest {
    private VodafoneUserAgent userAgent = null;
    private VodafoneType type = VodafoneType.UNKNOWN;
    private String id = null;
    private String name = null;
    private String seriesName = null;
    private String vendorId = null;
    private boolean monochrome = false;
    private int color = 0;
    private int displayWidth = 0;
    private int displayHeight = 0;
    private String geoCode = null;
    private String jsclVersion = null;
    private String region = null;
    private VodafoneSmaf smaf = null;
    private int smd = 0;
    private String notifyId = null;
    private boolean registerd = false;
    private UID uid = null;

    public VodafoneRequestImpl(HttpServletRequest request) throws IllegalRequestException {
        this.userAgent = new VodafoneUserAgentImpl(request);
        String s = request.getHeader("x-jphone-msname");
        if (s == null) {
            throw new IllegalRequestException();
        }
        this.id = s;
        String[] strings = s.split("_");
        this.name = strings[0];
        s = request.getHeader("x-jphone-color");
        if (s == null || !s.matches("^(C|G)[0-9]+$")) {
            throw new IllegalRequestException();
        }
        this.monochrome = s.charAt(0) == 'G';
        this.color = NumberUtils.toInt(s.substring(1));
        s = request.getHeader("x-jphone-display");
        if (s == null || !s.matches("^[0-9]{2,}\\*[0-9]{2,}$")) {
            throw new IllegalRequestException();
        }
        strings = s.split("\\*");
        this.displayWidth = NumberUtils.toInt(strings[0]);
        this.displayHeight = NumberUtils.toInt(strings[1]);
        s = request.getHeader("x-jphone-geocode");
        if (s != null) {
            try {
                this.geoCode = URLDecoder.decode(s, "Windows-31J");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if ((s = request.getHeader("x-jphone-java")) != null) {
            this.jsclVersion = s;
        }
        if ((s = request.getHeader("x-jphone-region")) != null) {
            this.region = s;
        }
        if ((s = request.getHeader("x-jphone-smaf")) != null) {
            this.smaf = new VodafoneSmafImpl(s);
        }
        if ((s = request.getHeader("x-jphone-sound")) != null) {
            this.smd = NumberUtils.toInt(s);
        }
        this.type = this.getMSType();
        this.parseName(this.name, this.type.getCategoryType());
        s = request.getHeader("x-jphone-notifyId");
        if (s != null && !s.matches("^[0-9a-zA-Z]{10}$")) {
            throw new IllegalRequestException();
        }
        this.notifyId = s;
        s = request.getHeader("x-jphone-registerd");
        if (s != null && s.length() != 0) {
            throw new IllegalRequestException();
        }
        this.registerd = s != null;
        this.uid = new UIDImpl(request);
    }

    private VodafoneType getMSType() {
        float g = this.userAgent.getGenerationVersion();
        String jscl = this.userAgent.getVappli() != null ? this.userAgent.getVappli().getJsclVersion() : null;
        if ((double)g >= 5.0) {
            return VodafoneType.W;
        }
        if ((double)g >= 4.3) {
            if (jscl != null) {
                if (jscl.compareTo("1.3.2") >= 0) {
                    return VodafoneType.P7;
                }
                if (jscl.compareTo("1.2.2") >= 0) {
                    return VodafoneType.P6;
                }
            }
            return VodafoneType.UNKNOWN_P;
        }
        if ((double)g >= 4.2) {
            if (jscl != null) {
                if (jscl.compareTo("1.2") >= 0) {
                    return VodafoneType.P5;
                }
                return VodafoneType.P4_2;
            }
            return VodafoneType.UNKNOWN_P;
        }
        if ((double)g >= 4.0) {
            return VodafoneType.P4_1;
        }
        if ((double)g >= 3.0) {
            if (this.jsclVersion != null && this.jsclVersion.equals("1.0")) {
                return VodafoneType.C4;
            }
            return VodafoneType.C3;
        }
        if ((double)g >= 2.0) {
            return VodafoneType.C2;
        }
        if ((double)g >= 1.0) {
            if (jscl != null) {
                return VodafoneType.X_3GC;
            }
            return VodafoneType.S_3GC;
        }
        return VodafoneType.UNKNOWN;
    }

    private void parseName(String name, VodafoneCategoryType category) {
        if (name == null) {
            return;
        }
        if (name.matches("^J-[A-Z]+[0-9]+[A-Z]*$")) {
            char c;
            int start = "J-".length();
            int end = -1;
            int i = start;
            while (i < name.length()) {
                c = name.charAt(i);
                if (c >= '0' && c <= '9') {
                    end = i;
                    break;
                }
                ++i;
            }
            if (end != -1) {
                this.vendorId = name.substring(start, end);
            }
            i = end + 1;
            while (i < name.length()) {
                c = name.charAt(i);
                if (c < '0' || c > '9') {
                    this.seriesName = "J-" + name.substring(end + 1, i);
                    break;
                }
                ++i;
            }
        } else if (name.matches("^V[0-9]{3}[A-Z]+[0-9a-z]*$")) {
            int i = 4;
            while (i < name.length()) {
                char c = name.charAt(i);
                if (c < 'A' || c > 'Z') {
                    this.vendorId = name.substring(5, i);
                    break;
                }
                ++i;
            }
            this.seriesName = category == VodafoneCategoryType.THREE_GC ? "3G" : "V" + name.charAt(1);
        }
    }

    public VodafoneUserAgent getUserAgent() {
        return this.userAgent;
    }

    public VodafoneType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public String getVendorId() {
        return this.vendorId;
    }

    public boolean isMonochrome() {
        return this.monochrome;
    }

    public int getColor() {
        return this.color;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public String getGeoCode() {
        return this.geoCode;
    }

    public String getJsclVersion() {
        return this.jsclVersion;
    }

    public String getRegion() {
        return this.region;
    }

    public VodafoneSmaf getSmaf() {
        return this.smaf;
    }

    public int getSmd() {
        return this.smd;
    }

    public String getNotifyId() {
        return this.notifyId;
    }

    public boolean getRegisterd() {
        return this.registerd;
    }

    public UID getUID() {
        return this.uid;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}

