/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.vodafone;

import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.livez.IllegalUserAgentException;
import jp.sourceforge.livez.UserAgentNotFoundException;
import jp.sourceforge.livez.vodafone.Application;
import jp.sourceforge.livez.vodafone.ApplicationImpl;
import jp.sourceforge.livez.vodafone.ApplicationType;
import jp.sourceforge.livez.vodafone.Vappli;
import jp.sourceforge.livez.vodafone.VappliImpl;
import jp.sourceforge.livez.vodafone.VodafoneUserAgent;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.NumberUtils;

final class VodafoneUserAgentImpl
implements VodafoneUserAgent {
    static final String JPHONE_MSNAME = "J-[A-Z]+[0-9]+[A-Z]*";
    static final String VODAFONE_MSNAME = "V[0-9]{3}[A-Z]+[0-9a-z]*";
    private static final String MSNAME = "(J-[A-Z]+[0-9]+[A-Z]*|V[0-9]{3}[A-Z]+[0-9a-z]*|V-XX111){1}(_[a-z]+)?";
    private static final String SERIAL_NUMBER = "SN[a-zA-Z0-9]{11,15}";
    private static final String MSVENDOR = "[A-Z]+/.+";
    private static final String MIDP = "Profile/MIDP-[0-9]\\.[0-9]";
    private static final String CLDC = "Configuration/CLDC-[0-9]\\.[0-9]";
    private static final String JSCL = "Ext-Profile/JSCL-[0-9]\\.[0-9]\\.[0-9]";
    private static final String USERAGENT_JPHONE = "^J-PHONE/[23456789]\\.[0-9]/(J-[A-Z]+[0-9]+[A-Z]*|V[0-9]{3}[A-Z]+[0-9a-z]*|V-XX111){1}(_[a-z]+)?(/SN[a-zA-Z0-9]{11,15})?( [A-Z]+/.+)?( Profile/MIDP-[0-9]\\.[0-9])?( Configuration/CLDC-[0-9]\\.[0-9])?( Ext-Profile/JSCL-[0-9]\\.[0-9]\\.[0-9])?$";
    private static final String UNTRUSTED = "UNTRUSTED/1.0";
    private static final String USERAGENT_UNTRUSTED = "^UNTRUSTED/1.0$";
    private static final String APPLICATION = "(Browser|Java|SVG|Flash)+/.+/.+";
    private static final String JSCL2 = "Ext-J-Profile/JSCL-[0-9]\\.[0-9]\\.[0-9]";
    private static final String VSCL = "Ext-V-Profile/VSCL-[0-9]\\.[0-9]\\.[0-9]";
    private static final String USERAGENT_VODAFONE = "^Vodafone/1\\.[0-9]/(J-[A-Z]+[0-9]+[A-Z]*|V[0-9]{3}[A-Z]+[0-9a-z]*|V-XX111){1}(_[a-z]+)?/.+(/SN[a-zA-Z0-9]{11,15})?.*( (Browser|Java|SVG|Flash)+/.+/.+)?( Profile/MIDP-[0-9]\\.[0-9])?( Configuration/CLDC-[0-9]\\.[0-9])?( (Ext-Profile/JSCL-[0-9]\\.[0-9]\\.[0-9]|Ext-J-Profile/JSCL-[0-9]\\.[0-9]\\.[0-9]){1})?( Ext-V-Profile/VSCL-[0-9]\\.[0-9]\\.[0-9])?(( |/){1}UNTRUSTED/1.0)?$";
    private static final String MOTOROLA_PREFIX = "MOT-";
    private static final String USERAGENT_MOTOROLA = "^MOT-.+/[a-zA-Z0-9]+\\.[a-zA-Z0-9]+\\.[a-zA-Z0-9]+( MIB/[0-9]\\.[0-9]\\.[0-9])?( Profile/MIDP-[0-9]\\.[0-9])?( Configuration/CLDC-[0-9]\\.[0-9])?$";
    private String value = null;
    private String id = null;
    private float generationVersion;
    private String serialNumber = null;
    private ApplicationImpl application = null;
    private VappliImpl vappli = null;

    public VodafoneUserAgentImpl(HttpServletRequest request) throws UserAgentNotFoundException, IllegalUserAgentException {
        this(request.getHeader("User-Agent"));
    }

    public VodafoneUserAgentImpl(String ua) throws UserAgentNotFoundException, IllegalUserAgentException {
        if (ua == null) {
            throw new UserAgentNotFoundException();
        }
        this.value = ua;
        String[] s = ua.split("/");
        if (this.value.matches(USERAGENT_JPHONE)) {
            this.id = s[2];
            this.generationVersion = NumberUtils.toFloat(s[1]);
        } else {
            if (this.value.matches(USERAGENT_UNTRUSTED)) {
                this.generationVersion = NumberUtils.toFloat("1.0");
                this.application = new ApplicationImpl(ApplicationType.JAVA);
                this.vappli = new VappliImpl(2.0f, 1.1f);
                return;
            }
            if (this.value.matches(USERAGENT_VODAFONE)) {
                this.id = s[2];
                this.generationVersion = NumberUtils.toFloat(s[1]);
            } else if (this.value.matches(USERAGENT_MOTOROLA)) {
                this.id = s[0].substring(MOTOROLA_PREFIX.length());
                this.generationVersion = 1.0f;
            } else {
                throw new IllegalUserAgentException(ua);
            }
        }
        int i = 3;
        while (i < s.length) {
            if (s[i].matches(SERIAL_NUMBER)) {
                this.serialNumber = s[i].substring(2);
            }
            ++i;
        }
        Float midp = null;
        Float cldc = null;
        String jscl = null;
        String vscl = null;
        boolean untrusted = false;
        s = ua.split(" ");
        int i2 = 1;
        while (i2 < s.length) {
            String[] strings;
            if (s[i2].matches(MIDP)) {
                midp = Float.valueOf(NumberUtils.toFloat(s[i2].substring(s[i2].lastIndexOf(45) + 1)));
            } else if (s[i2].matches(CLDC)) {
                cldc = Float.valueOf(NumberUtils.toFloat(s[i2].substring(s[i2].lastIndexOf(45) + 1)));
            } else if (s[i2].matches(JSCL) || s[i2].matches(JSCL2)) {
                jscl = s[i2].substring(s[i2].lastIndexOf(45) + 1);
            } else if (s[i2].matches(VSCL)) {
                vscl = s[i2].substring(s[i2].lastIndexOf(45) + 1);
            } else if (s[i2].startsWith("Browser/")) {
                strings = s[i2].split("/");
                this.application = new ApplicationImpl(ApplicationType.BROWSER, strings[1], Float.valueOf(NumberUtils.toFloat(strings[2])));
            } else if (s[i2].startsWith("Java/")) {
                strings = s[i2].split("/");
                this.application = new ApplicationImpl(ApplicationType.JAVA, strings[1], Float.valueOf(NumberUtils.toFloat(strings[2])));
            } else if (s[i2].startsWith("SVG/")) {
                strings = s[i2].split("/");
                this.application = new ApplicationImpl(ApplicationType.SVG, strings[1], Float.valueOf(NumberUtils.toFloat(strings[2])));
            } else if (s[i2].startsWith("Flash/")) {
                strings = s[i2].split("/");
                this.application = new ApplicationImpl(ApplicationType.FLASH, strings[1], Float.valueOf(NumberUtils.toFloat(strings[2])));
            }
            if (s[i2].indexOf(UNTRUSTED) != -1) {
                untrusted = true;
            }
            ++i2;
        }
        if (untrusted) {
            if (this.application == null) {
                this.application = new ApplicationImpl(ApplicationType.JAVA);
            }
            if (midp == null) {
                midp = Float.valueOf(2.0f);
            }
            if (cldc == null) {
                cldc = Float.valueOf(1.1f);
            }
        }
        if (midp != null || cldc != null || jscl != null || vscl != null) {
            this.vappli = new VappliImpl(midp.floatValue(), cldc.floatValue(), jscl, vscl);
        }
    }

    public String getValue() {
        return this.value;
    }

    public String getId() {
        return this.id;
    }

    public float getGenerationVersion() {
        return this.generationVersion;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public Application getApplication() {
        return this.application;
    }

    public Vappli getVappli() {
        return this.vappli;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}

