/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands.servlet;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.chain.commands.AbstractPerformForward;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.chain.contexts.ServletActionContext;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public class PerformForward
extends AbstractPerformForward {
    private static final Log LOG = LogFactory.getLog((Class)PerformForward.class);

    protected void perform(ActionContext context, ForwardConfig forwardConfig) throws Exception {
        ServletActionContext sacontext = (ServletActionContext)context;
        String forwardPath = forwardConfig.getPath();
        if (forwardPath == null) {
            ActionServlet servlet = sacontext.getActionServlet();
            MessageResources resources = servlet.getInternal();
            throw new IllegalArgumentException(resources.getMessage("forwardPathNull"));
        }
        ModuleConfig moduleConfig = context.getModuleConfig();
        String uri = forwardPath.startsWith("/") ? RequestUtils.forwardURL(sacontext.getRequest(), forwardConfig, moduleConfig) : forwardPath;
        HttpServletRequest request = sacontext.getRequest();
        HttpServletResponse response = sacontext.getResponse();
        if (response.isCommitted() && !forwardConfig.getRedirect()) {
            RequestDispatcher rd = sacontext.getContext().getRequestDispatcher(uri);
            if (rd == null) {
                response.sendError(500, "Error getting RequestDispatcher for " + uri);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Including " + uri));
            }
            rd.include((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (forwardConfig.getRedirect()) {
            if (uri.startsWith("/")) {
                uri = request.getContextPath() + uri;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Redirecting to " + uri));
            }
            sacontext.getResponse().sendRedirect(sacontext.getResponse().encodeRedirectURL(uri));
        } else {
            RequestDispatcher rd = sacontext.getContext().getRequestDispatcher(uri);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Forwarding to " + uri));
            }
            rd.forward((ServletRequest)request, (ServletResponse)sacontext.getResponse());
        }
    }
}

