/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;

public class PropertyMessageResources
extends MessageResources {
    protected static final Log log = LogFactory.getLog((Class)PropertyMessageResources.class);
    protected HashMap locales = new HashMap();
    protected HashMap messages = new HashMap();

    public PropertyMessageResources(MessageResourcesFactory factory, String config) {
        super(factory, config);
        log.trace((Object)("Initializing, config='" + config + "'"));
    }

    public PropertyMessageResources(MessageResourcesFactory factory, String config, boolean returnNull) {
        super(factory, config, returnNull);
        log.trace((Object)("Initializing, config='" + config + "', returnNull=" + returnNull));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage(Locale locale, String key) {
        HashMap hashMap;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMessage(" + locale + "," + key + ")"));
        }
        String localeKey = this.localeKey(locale);
        String originalKey = this.messageKey(localeKey, key);
        String messageKey = null;
        String message = null;
        int underscore = 0;
        boolean addIt = false;
        while (true) {
            this.loadLocale(localeKey);
            messageKey = this.messageKey(localeKey, key);
            hashMap = this.messages;
            synchronized (hashMap) {
                message = (String)this.messages.get(messageKey);
                if (message != null) {
                    if (addIt) {
                        this.messages.put(originalKey, message);
                    }
                    return message;
                }
            }
            addIt = true;
            underscore = localeKey.lastIndexOf("_");
            if (underscore < 0) break;
            localeKey = localeKey.substring(0, underscore);
        }
        if (!this.defaultLocale.equals(locale)) {
            localeKey = this.localeKey(this.defaultLocale);
            messageKey = this.messageKey(localeKey, key);
            this.loadLocale(localeKey);
            hashMap = this.messages;
            synchronized (hashMap) {
                message = (String)this.messages.get(messageKey);
                if (message != null) {
                    this.messages.put(originalKey, message);
                    return message;
                }
            }
        }
        localeKey = "";
        messageKey = this.messageKey(localeKey, key);
        this.loadLocale(localeKey);
        hashMap = this.messages;
        synchronized (hashMap) {
            message = (String)this.messages.get(messageKey);
            if (message != null) {
                this.messages.put(originalKey, message);
                return message;
            }
        }
        if (this.returnNull) {
            return null;
        }
        return "???" + this.messageKey(locale, key) + "???";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected synchronized void loadLocale(String localeKey) {
        Properties props;
        block21: {
            ClassLoader classLoader;
            if (log.isTraceEnabled()) {
                log.trace((Object)("loadLocale(" + localeKey + ")"));
            }
            if (this.locales.get(localeKey) != null) {
                return;
            }
            this.locales.put(localeKey, localeKey);
            String name = this.config.replace('.', '/');
            if (localeKey.length() > 0) {
                name = name + "_" + localeKey;
            }
            name = name + ".properties";
            InputStream is = null;
            props = new Properties();
            if (log.isTraceEnabled()) {
                log.trace((Object)("  Loading resource '" + name + "'"));
            }
            if ((classLoader = Thread.currentThread().getContextClassLoader()) == null) {
                classLoader = this.getClass().getClassLoader();
            }
            if ((is = classLoader.getResourceAsStream(name)) != null) {
                props.load(is);
                Object var8_6 = null;
                try {
                    is.close();
                }
                catch (IOException e2) {
                    log.error((Object)"loadLocale()", (Throwable)e2);
                }
                break block21;
                {
                    catch (IOException e) {
                        log.error((Object)"loadLocale()", (Throwable)e);
                        var8_6 = null;
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            log.error((Object)"loadLocale()", (Throwable)e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        log.error((Object)"loadLocale()", (Throwable)e2);
                    }
                    throw throwable;
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"  Loading resource completed");
        }
        if (props.size() < 1) {
            return;
        }
        HashMap hashMap = this.messages;
        synchronized (hashMap) {
            Iterator<Object> names = props.keySet().iterator();
            while (names.hasNext()) {
                String key = (String)names.next();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  Saving message key '" + this.messageKey(localeKey, key)));
                }
                this.messages.put(this.messageKey(localeKey, key), props.getProperty(key));
            }
        }
    }
}

