/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.support;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.NestedRuntimeException;
import org.springframework.jmx.support.JmxUtils;
import org.springframework.jmx.support.ObjectNameManager;

public class ConnectorServerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    public static final String DEFAULT_SERVICE_URL = "service:jmx:jmxmp://localhost:9875";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private MBeanServer server;
    private String serviceUrl = "service:jmx:jmxmp://localhost:9875";
    private Map environment;
    private ObjectName objectName;
    private boolean threaded = false;
    private boolean daemon = false;
    private JMXConnectorServer connectorServer;
    static /* synthetic */ Class class$javax$management$remote$JMXConnectorServer;

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setEnvironment(Properties environment) {
        this.environment = environment;
    }

    public void setEnvironmentMap(Map environment) {
        this.environment = environment;
    }

    public void setObjectName(String objectName) throws MalformedObjectNameException {
        this.objectName = ObjectNameManager.getInstance(objectName);
    }

    public void setThreaded(boolean threaded) {
        this.threaded = threaded;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void afterPropertiesSet() throws JMException, IOException {
        if (this.server == null) {
            this.server = JmxUtils.locateMBeanServer();
        }
        JMXServiceURL url = new JMXServiceURL(this.serviceUrl);
        this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, this.environment, this.server);
        if (this.objectName != null) {
            this.server.registerMBean(this.connectorServer, this.objectName);
        }
        try {
            if (this.threaded) {
                Thread connectorThread = new Thread(){

                    public void run() {
                        try {
                            ConnectorServerFactoryBean.this.connectorServer.start();
                        }
                        catch (IOException ex) {
                            throw new DelayedConnectorStartException(ex);
                        }
                    }
                };
                connectorThread.setName("JMX Connector Thread [" + this.serviceUrl + "]");
                connectorThread.setDaemon(this.daemon);
                connectorThread.start();
            } else {
                this.connectorServer.start();
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("JMX connector server started: " + this.connectorServer));
            }
        }
        catch (IOException ex) {
            this.unregisterConnectorServer();
            throw ex;
        }
    }

    public Object getObject() {
        return this.connectorServer;
    }

    public Class getObjectType() {
        return this.connectorServer != null ? this.connectorServer.getClass() : (class$javax$management$remote$JMXConnectorServer == null ? (class$javax$management$remote$JMXConnectorServer = ConnectorServerFactoryBean.class$("javax.management.remote.JMXConnectorServer")) : class$javax$management$remote$JMXConnectorServer);
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws IOException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Stopping JMX connector server: " + this.connectorServer));
        }
        try {
            this.connectorServer.stop();
        }
        finally {
            this.unregisterConnectorServer();
        }
    }

    private void unregisterConnectorServer() {
        if (this.objectName != null) {
            try {
                this.server.unregisterMBean(this.objectName);
            }
            catch (JMException ex) {
                this.logger.error((Object)"Could not unregister JMX connector server", (Throwable)ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DelayedConnectorStartException
    extends NestedRuntimeException {
        private DelayedConnectorStartException(IOException ex) {
            super("Could not start JMX connector server after delay", ex);
        }
    }
}

