/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.IllegalRequestParameterException;
import com.meterware.httpunit.RadioButtonFormControl;
import com.meterware.httpunit.RadioGroupFormControl;
import com.meterware.httpunit.UploadFileSpec;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.util.ArrayList;
import java.util.Arrays;

class FormParameter {
    private FormControl[] _controls;
    private ArrayList _controlList = new ArrayList();
    private RadioGroupFormControl _group;
    private String _name;

    FormParameter() {
    }

    void addControl(FormControl control) {
        this._controls = null;
        if (this._name == null) {
            this._name = control.getName();
        }
        if (!this._name.equalsIgnoreCase(control.getName())) {
            throw new RuntimeException("all controls should have the same name");
        }
        if (control.isExclusive()) {
            this.getRadioGroup(control.getForm()).addRadioButton((RadioButtonFormControl)control);
        } else {
            this._controlList.add(control);
        }
    }

    private FormControl[] getControls() {
        if (this._controls == null) {
            this._controls = this._controlList.toArray(new FormControl[this._controlList.size()]);
        }
        return this._controls;
    }

    Object getScriptableObject() {
        if (this.getControls().length == 1) {
            return this.getControls()[0].getDelegate();
        }
        ArrayList<ScriptableDelegate> list = new ArrayList<ScriptableDelegate>();
        int i = 0;
        while (i < this._controls.length) {
            FormControl control = this._controls[i];
            list.add(control.getScriptableDelegate());
            ++i;
        }
        return list.toArray(new ScriptableDelegate[list.size()]);
    }

    String[] getValues() {
        ArrayList<String> valueList = new ArrayList<String>();
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            valueList.addAll(Arrays.asList(controls[i].getValues()));
            ++i;
        }
        return valueList.toArray(new String[valueList.size()]);
    }

    void setValues(String[] values) {
        ArrayList<String> list = new ArrayList<String>(values.length);
        list.addAll(Arrays.asList(values));
        int i = 0;
        while (i < this.getControls().length) {
            this.getControls()[i].claimRequiredValues(list);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.getControls().length) {
            this.getControls()[i2].claimUniqueValue(list);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.getControls().length) {
            this.getControls()[i3].claimValue(list);
            ++i3;
        }
        if (!list.isEmpty()) {
            throw new UnusedParameterValueException(this._name, (String)list.get(0));
        }
    }

    public void toggleCheckbox() {
        FormControl[] controls = this.getControls();
        if (controls.length != 1) {
            throw new IllegalCheckboxParameterException(this._name, "toggleCheckbox");
        }
        controls[0].toggle();
    }

    public void toggleCheckbox(String value) {
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            FormControl control = controls[i];
            if (value.equals(control.getValueAttribute())) {
                control.toggle();
                return;
            }
            ++i;
        }
        throw new IllegalCheckboxParameterException(this._name + "/" + value, "toggleCheckbox");
    }

    public void setValue(boolean state) {
        FormControl[] controls = this.getControls();
        if (controls.length != 1) {
            throw new IllegalCheckboxParameterException(this._name, "setCheckbox");
        }
        controls[0].setState(state);
    }

    public void setValue(String value, boolean state) {
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            FormControl control = controls[i];
            if (value.equals(control.getValueAttribute())) {
                control.setState(state);
                return;
            }
            ++i;
        }
        throw new IllegalCheckboxParameterException(this._name + "/" + value, "setCheckbox");
    }

    void setFiles(UploadFileSpec[] fileArray) {
        ArrayList<UploadFileSpec> list = new ArrayList<UploadFileSpec>(fileArray.length);
        list.addAll(Arrays.asList(fileArray));
        int i = 0;
        while (i < this.getControls().length) {
            this.getControls()[i].claimUploadSpecification(list);
            ++i;
        }
        if (!list.isEmpty()) {
            throw new UnusedUploadFileException(this._name, fileArray.length - list.size(), fileArray.length);
        }
    }

    String[] getOptions() {
        ArrayList<String> optionList = new ArrayList<String>();
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            optionList.addAll(Arrays.asList(controls[i].getDisplayedOptions()));
            ++i;
        }
        return optionList.toArray(new String[optionList.size()]);
    }

    String[] getOptionValues() {
        ArrayList<String> valueList = new ArrayList<String>();
        int i = 0;
        while (i < this.getControls().length) {
            valueList.addAll(Arrays.asList(this.getControls()[i].getOptionValues()));
            ++i;
        }
        return valueList.toArray(new String[valueList.size()]);
    }

    boolean isMultiValuedParameter() {
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            if (controls[i].isMultiValued()) {
                return true;
            }
            if (!controls[i].isExclusive() && controls.length > 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int getNumTextParameters() {
        int result = 0;
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            if (controls[i].isTextControl()) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    boolean isTextParameter() {
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            if (controls[i].isTextControl()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean isFileParameter() {
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            if (controls[i].isFileParameter()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean isDisabledParameter() {
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            if (!controls[i].isDisabled()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean isReadOnlyParameter() {
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            if (!controls[i].isReadOnly()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isHiddenParameter() {
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            if (!controls[i].isHidden()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private RadioGroupFormControl getRadioGroup(WebForm form) {
        if (this._group == null) {
            this._group = new RadioGroupFormControl(form);
            this._controlList.add(this._group);
        }
        return this._group;
    }

    static class IllegalCheckboxParameterException
    extends IllegalRequestParameterException {
        private String _parameterName;
        private String _methodName;

        IllegalCheckboxParameterException(String parameterName, String methodName) {
            this._parameterName = parameterName;
            this._methodName = methodName;
        }

        public String getMessage() {
            StringBuffer sb = new StringBuffer(2048);
            sb.append("Attempted to invoke method '").append(this._methodName);
            sb.append("' for parameter '").append(this._parameterName).append("', which is not a unique checkbox control.");
            return sb.toString();
        }
    }

    class UnusedUploadFileException
    extends IllegalRequestParameterException {
        private String _parameterName;
        private int _numExpected;
        private int _numSupplied;

        UnusedUploadFileException(String parameterName, int numFilesExpected, int numFilesSupplied) {
            this._parameterName = parameterName;
            this._numExpected = numFilesExpected;
            this._numSupplied = numFilesSupplied;
        }

        public String getMessage() {
            StringBuffer sb = new StringBuffer(2048);
            sb.append("Attempted to upload ").append(this._numSupplied).append(" files using parameter '").append(this._parameterName);
            if (this._numExpected == 0) {
                sb.append("' which is not a file parameter.");
            } else {
                sb.append("' which only has room for ").append(this._numExpected).append('.');
            }
            return sb.toString();
        }
    }

    class UnusedParameterValueException
    extends IllegalRequestParameterException {
        private String _parameterName;
        private String _badValue;

        UnusedParameterValueException(String parameterName, String badValue) {
            this._parameterName = parameterName;
            this._badValue = badValue;
        }

        public String getMessage() {
            StringBuffer sb = new StringBuffer(2048);
            sb.append("Attempted to assign to parameter '").append(this._parameterName);
            sb.append("' the extraneous value '").append(this._badValue).append("'.");
            return sb.toString();
        }
    }
}

