/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SingleConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ConnectionFactory targetConnectionFactory;
    private Connection target;
    private Connection connection;
    static /* synthetic */ Class class$javax$jms$Connection;
    static /* synthetic */ Class class$javax$jms$QueueConnection;
    static /* synthetic */ Class class$javax$jms$TopicConnection;

    public SingleConnectionFactory() {
    }

    public SingleConnectionFactory(Connection target) {
        this.target = target;
        this.connection = this.getCloseSuppressingConnectionProxy(target);
        this.afterPropertiesSet();
    }

    public SingleConnectionFactory(ConnectionFactory targetConnectionFactory) {
        this.targetConnectionFactory = targetConnectionFactory;
        this.afterPropertiesSet();
    }

    public void setTargetConnectionFactory(ConnectionFactory targetConnectionFactory) {
        this.targetConnectionFactory = targetConnectionFactory;
    }

    public ConnectionFactory getTargetConnectionFactory() {
        return this.targetConnectionFactory;
    }

    public void afterPropertiesSet() {
        if (this.connection == null && this.targetConnectionFactory == null) {
            throw new IllegalArgumentException("connection or targetConnectionFactory is required");
        }
    }

    protected void init() throws JMSException {
        if (this.targetConnectionFactory == null) {
            throw new java.lang.IllegalStateException("targetConnectionFactory is required for lazily initializing a connection");
        }
        Connection target = this.doCreateConnection();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created single connection: " + target));
        }
        this.target = target;
        this.connection = this.getCloseSuppressingConnectionProxy(target);
    }

    protected Connection doCreateConnection() throws JMSException {
        return this.targetConnectionFactory.createConnection();
    }

    public void destroy() throws JMSException {
        if (this.target != null) {
            this.target.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection createConnection() throws JMSException {
        SingleConnectionFactory singleConnectionFactory = this;
        synchronized (singleConnectionFactory) {
            if (this.connection == null) {
                this.init();
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Returning single connection: " + this.connection));
        }
        return this.connection;
    }

    public Connection createConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("SingleConnectionFactory does not support custom username and password");
    }

    public QueueConnection createQueueConnection() throws JMSException {
        Connection con = this.createConnection();
        if (!(con instanceof QueueConnection)) {
            throw new IllegalStateException("This SingleConnectionFactory does not hold a QueueConnection but rather: " + con);
        }
        return (QueueConnection)con;
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("SingleConnectionFactory does not support custom username and password");
    }

    public TopicConnection createTopicConnection() throws JMSException {
        Connection con = this.createConnection();
        if (!(con instanceof TopicConnection)) {
            throw new IllegalStateException("This SingleConnectionFactory does not hold a TopicConnection but rather: " + con);
        }
        return (TopicConnection)con;
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("SingleConnectionFactory does not support custom username and password");
    }

    protected Connection getCloseSuppressingConnectionProxy(Connection target) {
        ArrayList<Class> classes = new ArrayList<Class>(3);
        classes.add(class$javax$jms$Connection == null ? (class$javax$jms$Connection = SingleConnectionFactory.class$("javax.jms.Connection")) : class$javax$jms$Connection);
        if (target instanceof QueueConnection) {
            classes.add(class$javax$jms$QueueConnection == null ? (class$javax$jms$QueueConnection = SingleConnectionFactory.class$("javax.jms.QueueConnection")) : class$javax$jms$QueueConnection);
        }
        if (target instanceof TopicConnection) {
            classes.add(class$javax$jms$TopicConnection == null ? (class$javax$jms$TopicConnection = SingleConnectionFactory.class$("javax.jms.TopicConnection")) : class$javax$jms$TopicConnection);
        }
        return (Connection)Proxy.newProxyInstance((class$javax$jms$Connection == null ? (class$javax$jms$Connection = SingleConnectionFactory.class$("javax.jms.Connection")) : class$javax$jms$Connection).getClassLoader(), classes.toArray(new Class[classes.size()]), (InvocationHandler)new CloseSuppressingInvocationHandler(target));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        private CloseSuppressingInvocationHandler(Connection source) {
            this.target = source;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

