/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.beans.PropertyEditorSupport;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.util.StringUtils;

public class TransactionAttributeEditor
extends PropertyEditorSupport {
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null || "".equals(text)) {
            this.setValue(null);
        } else {
            String[] tokens = StringUtils.commaDelimitedListToStringArray(text);
            RuleBasedTransactionAttribute attr = new RuleBasedTransactionAttribute();
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i].trim();
                if (token.startsWith("PROPAGATION")) {
                    attr.setPropagationBehaviorName(token);
                    continue;
                }
                if (token.startsWith("ISOLATION")) {
                    attr.setIsolationLevelName(token);
                    continue;
                }
                if (token.startsWith("timeout_")) {
                    String value = token.substring("timeout_".length());
                    attr.setTimeout(Integer.parseInt(value));
                    continue;
                }
                if (token.equals("readOnly")) {
                    attr.setReadOnly(true);
                    continue;
                }
                if (token.startsWith("+")) {
                    attr.getRollbackRules().add(new NoRollbackRuleAttribute(token.substring(1)));
                    continue;
                }
                if (token.startsWith("-")) {
                    attr.getRollbackRules().add(new RollbackRuleAttribute(token.substring(1)));
                    continue;
                }
                throw new IllegalArgumentException("Illegal transaction attribute token: [" + token + "]");
            }
            this.setValue(attr);
        }
    }
}

