/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.pages;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import jp.sourceforge.livez.pages.FrameSetHandler;
import jp.sourceforge.livez.pages.HTMLOverview;
import jp.sourceforge.livez.pages.HTMLParser;
import org.apache.commons.io.IOUtils;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.cyberneko.html.filters.ElementRemover;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class FrameSetConverter {
    private static final ElementRemover remover = new ElementRemover();

    static {
        remover.acceptElement("frame", new String[]{"src", "name"});
    }

    private FrameSetConverter() {
    }

    public static String convert(byte[] bytes, String encoding, URL base, HTMLOverview header) throws IOException, SAXException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            String string = FrameSetConverter.convert(in, encoding, base, header);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static String convert(InputStream in, String encoding, URL base, HTMLOverview header) throws IOException, SAXException {
        InputSource input = new InputSource(in);
        if (encoding != null) {
            input.setEncoding(encoding);
        }
        return FrameSetConverter.convert(input, base, header);
    }

    private static String convert(InputSource input, URL base, HTMLOverview header) throws IOException, SAXException {
        FrameSetHandler handler = new FrameSetHandler(base, header);
        HTMLParser.parse(input, handler, new XMLDocumentFilter[]{remover});
        return handler.getPage();
    }
}

