/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.pages;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import jp.sourceforge.livez.lang.StringEscapeUtils;
import jp.sourceforge.livez.pages.FramePageConverter;
import jp.sourceforge.livez.pages.HTMLAnalyzer;
import jp.sourceforge.livez.pages.HTMLOverview;
import jp.sourceforge.livez.pages.HTMLType;
import jp.sourceforge.livez.util.URLUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

final class FrameSetHandler
extends DefaultHandler2 {
    private StringBuilder page;
    private URL base = null;
    private HTMLOverview header;

    public String getPage() {
        return this.page.toString();
    }

    public FrameSetHandler(URL base, HTMLOverview header) {
        if (header.getBaseURI() != null) {
            try {
                this.base = header.getBaseURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.base == null) {
            this.base = base;
        }
        this.header = header;
    }

    public void startDocument() {
        this.page = new StringBuilder(2048);
        this.page.append("<html>");
        this.page.append(this.header.render());
        this.page.append("<body>");
    }

    public void endDocument() {
        this.page.append("</body>");
        this.page.append("</html>");
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        String name = attributes.getValue("name");
        String src = attributes.getValue("src");
        boolean success = false;
        URL url = this.processPath(src);
        if (url != null) {
            try {
                success = this.process(url, src, name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!success) {
            this.processAnchor(src, name);
        }
    }

    private URL processPath(String src) {
        try {
            URI uri = new URI(src);
            if (!uri.isAbsolute()) {
                uri = this.base.toURI().resolve(uri);
            }
            return uri.toURL();
        }
        catch (URISyntaxException e) {
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private boolean process(URL url, String src, String name) throws IOException {
        URLConnection con = URLUtils.getURLConnection(url);
        con.connect();
        String type = con.getContentType();
        if (type == null) {
            return false;
        }
        if (type.startsWith("image/")) {
            this.processImage(src, name);
            return true;
        }
        byte[] bytes = URLUtils.getByteArray(con);
        String charset = URLUtils.getCharSet(con);
        if (type.startsWith("text/plain")) {
            try {
                this.page.append("<div>");
                this.page.append("<pre>");
                this.page.append(StringEscapeUtils.escapeHtml(new String(bytes, charset)));
                this.page.append("</pre>");
                this.page.append("</div>");
                return true;
            }
            catch (IOException iOException) {}
        } else if (type.startsWith("text/html") || type.startsWith("text/xhtml") || type.startsWith("application/xhtml+xml")) {
            try {
                HTMLOverview ph = HTMLAnalyzer.analyze(bytes, charset);
                if (ph.getType() == null) {
                    return true;
                }
                if (ph.getType() == HTMLType.CONTENTS) {
                    this.page.append(FramePageConverter.convert(bytes, charset));
                    return true;
                }
            }
            catch (IOException iOException) {
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        return false;
    }

    private void processImage(String src, String name) {
        this.page.append("<div>");
        this.page.append("<img src=\"");
        this.page.append(src);
        this.page.append('\"');
        if (StringUtils.isNotEmpty((String)name)) {
            this.page.append(" alt=\"");
            this.page.append(name);
            this.page.append('\"');
        }
        this.page.append('>');
        this.page.append("</div>");
    }

    private void processAnchor(String src, String name) {
        this.page.append("<div>");
        this.page.append("<a href=\"");
        this.page.append(src);
        this.page.append("\">");
        this.page.append(StringUtils.isNotEmpty((String)name) ? name : src);
        this.page.append("</a>");
        this.page.append("</div>");
    }
}

