/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.pages;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.livez.pages.HTMLAnalyzerHandler;
import jp.sourceforge.livez.pages.HTMLOverview;
import jp.sourceforge.livez.pages.HTMLParser;
import org.apache.commons.io.IOUtils;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.cyberneko.html.filters.ElementRemover;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class HTMLAnalyzer {
    private static final ElementRemover remover = new ElementRemover();

    static {
        remover.acceptElement("base", new String[]{"href"});
        remover.acceptElement("title", null);
        remover.acceptElement("body", null);
        remover.acceptElement("frameset", null);
    }

    private HTMLAnalyzer() {
    }

    public static HTMLOverview analyze(byte[] bytes, String encoding) throws IOException, SAXException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            HTMLOverview hTMLOverview = HTMLAnalyzer.analyze(in, encoding);
            return hTMLOverview;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static HTMLOverview analyze(InputStream in, String encoding) throws IOException, SAXException {
        InputSource input = new InputSource(in);
        if (encoding != null) {
            input.setEncoding(encoding);
        }
        return HTMLAnalyzer.analyze(input);
    }

    private static HTMLOverview analyze(InputSource input) throws IOException, SAXException {
        HTMLAnalyzerHandler handler = new HTMLAnalyzerHandler();
        HTMLParser.parse(input, handler, new XMLDocumentFilter[]{remover});
        return handler.getOverview();
    }
}

