/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.pages;

import java.net.URI;
import jp.sourceforge.livez.lang.StringEscapeUtils;
import jp.sourceforge.livez.pages.HTMLType;
import org.apache.commons.lang.StringUtils;

final class HTMLOverview {
    private String title;
    private URI baseURI;
    private HTMLType type;

    public HTMLOverview() {
        this.title = null;
        this.baseURI = null;
        this.type = null;
    }

    public HTMLOverview(String title, URI baseURI, HTMLType pageType) {
        this.title = title;
        this.baseURI = baseURI;
        this.type = pageType;
    }

    public String getTitle() {
        return this.title;
    }

    void setTitle(String title) {
        this.title = title;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
    }

    public HTMLType getType() {
        return this.type;
    }

    void setType(HTMLType type) {
        this.type = type;
    }

    public String render() {
        StringBuilder sb = new StringBuilder(562);
        sb.append("<head>");
        if (this.baseURI != null) {
            sb.append("<base href=\"");
            sb.append(this.baseURI.toString());
            sb.append("\">");
        }
        if (StringUtils.isNotEmpty((String)this.title)) {
            sb.append("<title>");
            sb.append(StringEscapeUtils.escapeHtml(this.title));
            sb.append("</title>");
        }
        sb.append("</head>");
        return sb.toString();
    }
}

