/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.vodafone;

import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.livez.IllegalUserIdException;
import jp.sourceforge.livez.vodafone.UID;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

final class UIDImpl
implements UID {
    private static final long serialVersionUID = 1L;
    private String value;
    private boolean disabled;
    private boolean cType;
    private char region;
    private String userId;

    public UIDImpl(String uid) throws IllegalUserIdException {
        this.parse(uid);
    }

    public UIDImpl(HttpServletRequest request) throws IllegalUserIdException {
        this.parse(request.getHeader("x-jphone-uid"));
    }

    private void parse(String uid) throws IllegalUserIdException {
        this.value = uid;
        if (uid == null || uid.equals("NULL")) {
            this.disabled = true;
            this.cType = false;
            this.region = '\u0000';
            this.userId = null;
        } else if (uid.matches("^[123456789][0-9a-zA-Z]{15}$")) {
            this.disabled = false;
            this.cType = true;
            this.region = uid.charAt(0);
            this.userId = uid.substring(1);
        } else if (uid.matches("^[abcdefghi][0-9a-zA-Z]{15}$")) {
            this.disabled = false;
            this.cType = false;
            this.region = uid.charAt(0);
            this.userId = uid.substring(1);
        } else {
            throw new IllegalUserIdException();
        }
    }

    public String getValue() {
        return this.value;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isCtype() {
        return this.cType;
    }

    public char getRegion() {
        return this.region;
    }

    public String getUserId() {
        return this.userId;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

