/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.IOException;
import org.freehep.graphicsio.font.truetype.TTFHHeaTable;
import org.freehep.graphicsio.font.truetype.TTFMaxPTable;
import org.freehep.graphicsio.font.truetype.TTFTable;

public class TTFHMtxTable
extends TTFTable {
    public int[] advanceWidth;
    public short[] leftSideBearing;
    public short[] leftSideBearing2;

    public String getTag() {
        return "hmtx";
    }

    public void readTable() throws IOException {
        int numberOfHMetrics = ((TTFHHeaTable)this.getTable((String)"hhea")).numberOfHMetrics;
        int numGlyphs = ((TTFMaxPTable)this.getTable((String)"maxp")).numGlyphs;
        this.advanceWidth = new int[numberOfHMetrics];
        this.leftSideBearing = new short[numberOfHMetrics];
        int i = 0;
        while (i < numberOfHMetrics) {
            this.advanceWidth[i] = this.ttf.readUFWord();
            this.leftSideBearing[i] = this.ttf.readFWord();
            ++i;
        }
        this.leftSideBearing2 = this.ttf.readShortArray(numGlyphs - numberOfHMetrics);
    }

    public String toString() {
        String str = super.toString();
        str = str + "\n  hMetrics[" + this.advanceWidth.length + "] = {";
        int i = 0;
        while (i < this.advanceWidth.length) {
            if (i % 8 == 0) {
                str = str + "\n    ";
            }
            str = str + "(" + this.advanceWidth[i] + "," + this.leftSideBearing[i] + ") ";
            ++i;
        }
        str = str + "\n  }";
        str = str + "\n  lsb[" + this.leftSideBearing2.length + "] = {";
        int i2 = 0;
        while (i2 < this.leftSideBearing2.length) {
            if (i2 % 16 == 0) {
                str = str + "\n    ";
            }
            str = str + this.leftSideBearing2[i2] + " ";
            ++i2;
        }
        str = str + "\n  }";
        return str;
    }
}

