/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.ObjectExistsException;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.ConfigurationHelper;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.event.CacheManagerEventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CacheManager {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager).getName());
    private static final Set ALL_CACHE_MANAGER_DISK_STORE_PATHS = Collections.synchronizedSet(new HashSet());
    private static CacheManager singleton;
    private final Map caches = new HashMap();
    private Cache defaultCache;
    private String diskStorePath;
    private CacheManagerEventListener cacheManagerEventListener;
    private Status status = Status.STATUS_UNINITIALISED;
    private CacheManagerPeerProvider cacheManagerPeerProvider;
    private CacheManagerPeerListener cacheManagerPeerListener;
    static /* synthetic */ Class class$net$sf$ehcache$CacheManager;

    public CacheManager(Configuration configuration) throws CacheException {
        this.init(configuration, null, null, null);
    }

    public CacheManager(String configurationFileName) throws CacheException {
        this.init(null, configurationFileName, null, null);
    }

    public CacheManager(URL configurationURL) throws CacheException {
        this.init(null, null, configurationURL, null);
    }

    public CacheManager(InputStream configurationInputStream) throws CacheException {
        this.init(null, null, null, configurationInputStream);
    }

    public CacheManager() throws CacheException {
        this.init(null, null, null, null);
    }

    private void init(Configuration configuration, String configurationFileName, URL configurationURL, InputStream configurationInputStream) {
        Configuration localConfiguration = configuration;
        if (configuration == null) {
            localConfiguration = this.parseConfiguration(configurationFileName, configurationURL, configurationInputStream);
        } else {
            localConfiguration.setSource("Programmatically configured.");
        }
        ConfigurationHelper configurationHelper = new ConfigurationHelper(this, localConfiguration);
        this.configure(configurationHelper);
        this.status = Status.STATUS_ALIVE;
        if (this.cacheManagerPeerListener != null) {
            this.cacheManagerPeerListener.init();
        }
        if (this.cacheManagerPeerProvider != null) {
            this.cacheManagerPeerProvider.init();
        }
    }

    private synchronized Configuration parseConfiguration(String configurationFileName, URL configurationURL, InputStream configurationInputStream) throws CacheException {
        String configurationSource;
        Configuration configuration;
        this.reinitialisationCheck();
        if (configurationFileName != null) {
            LOG.debug((Object)("Configuring CacheManager from " + configurationFileName));
            configuration = ConfigurationFactory.parseConfiguration(new File(configurationFileName));
            configurationSource = "file located at " + configurationFileName;
        } else if (configurationURL != null) {
            configuration = ConfigurationFactory.parseConfiguration(configurationURL);
            configurationSource = "URL of " + configurationURL;
        } else if (configurationInputStream != null) {
            configuration = ConfigurationFactory.parseConfiguration(configurationInputStream);
            configurationSource = "InputStream " + configurationInputStream;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Configuring ehcache from classpath.");
            }
            configuration = ConfigurationFactory.parseConfiguration();
            configurationSource = "classpath";
        }
        configuration.setSource(configurationSource);
        return configuration;
    }

    private void configure(ConfigurationHelper configurationHelper) {
        this.diskStorePath = configurationHelper.getDiskStorePath();
        if (!ALL_CACHE_MANAGER_DISK_STORE_PATHS.add(this.diskStorePath)) {
            throw new CacheException("Cannot parseConfiguration CacheManager. Attempt to create a new instance of CacheManager using the diskStorePath \"" + this.diskStorePath + "\" which is already used" + " by an existing CacheManager. The source of the configuration was " + configurationHelper.getConfigurationBean().getConfigurationSource() + ".");
        }
        this.cacheManagerEventListener = configurationHelper.createCacheManagerEventListener();
        this.cacheManagerPeerListener = configurationHelper.createCachePeerListener();
        this.cacheManagerPeerProvider = configurationHelper.createCachePeerProvider();
        this.defaultCache = configurationHelper.createDefaultCache();
        Set unitialisedCaches = configurationHelper.createCaches();
        Iterator iterator = unitialisedCaches.iterator();
        while (iterator.hasNext()) {
            Cache unitialisedCache = (Cache)iterator.next();
            this.addCacheNoCheck(unitialisedCache);
        }
    }

    private void reinitialisationCheck() throws IllegalStateException {
        if (this.defaultCache != null || this.diskStorePath != null || this.caches.size() != 0 || this.status.equals(Status.STATUS_SHUTDOWN)) {
            throw new IllegalStateException("Attempt to reinitialise the Cache Manager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create() throws CacheException {
        Class clazz = class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager;
        synchronized (clazz) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Creating new CacheManager with default config");
                }
                singleton = new CacheManager();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Attempting to create an existing singleton. Existing singleton returned.");
            }
            return singleton;
        }
    }

    public static CacheManager getInstance() throws CacheException {
        return CacheManager.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(String configurationFileName) throws CacheException {
        Class clazz = class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager;
        synchronized (clazz) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Creating new CacheManager with config file: " + configurationFileName));
                }
                singleton = new CacheManager(configurationFileName);
            }
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(URL configurationFileURL) throws CacheException {
        Class clazz = class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager;
        synchronized (clazz) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Creating new CacheManager with config URL: " + configurationFileURL));
                }
                singleton = new CacheManager(configurationFileURL);
            }
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(InputStream inputStream) throws CacheException {
        Class clazz = class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager;
        synchronized (clazz) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Creating new CacheManager with InputStream");
                }
                singleton = new CacheManager(inputStream);
            }
            return singleton;
        }
    }

    public synchronized Cache getCache(String name) throws IllegalStateException {
        this.checkStatus();
        return (Cache)this.caches.get(name);
    }

    public synchronized void addCache(String cacheName) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (cacheName == null || cacheName.length() == 0) {
            return;
        }
        if (this.caches.get(cacheName) != null) {
            throw new ObjectExistsException("Cache " + cacheName + " already exists");
        }
        Cache cache = null;
        try {
            cache = (Cache)this.defaultCache.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Object)("Failure adding cache. Initial cause was " + e.getMessage()), (Throwable)e);
        }
        if (cache != null) {
            cache.setName(cacheName);
        }
        this.addCache(cache);
    }

    public synchronized void addCache(Cache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        this.addCacheNoCheck(cache);
    }

    private synchronized void addCacheNoCheck(Cache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        if (this.caches.get(cache.getName()) != null) {
            throw new ObjectExistsException("Cache " + cache.getName() + " already exists");
        }
        cache.initialise();
        cache.setCacheManager(this);
        this.caches.put(cache.getName(), cache);
        if (this.cacheManagerEventListener != null) {
            this.cacheManagerEventListener.notifyCacheAdded(cache.getName());
        }
    }

    public synchronized boolean cacheExists(String cacheName) throws IllegalStateException {
        this.checkStatus();
        return this.caches.get(cacheName) != null;
    }

    public synchronized void removalAll() {
        String[] cacheNames = this.getCacheNames();
        for (int i = 0; i < cacheNames.length; ++i) {
            String cacheName = cacheNames[i];
            this.removeCache(cacheName);
        }
    }

    public synchronized void removeCache(String cacheName) throws IllegalStateException {
        this.checkStatus();
        if (cacheName == null || cacheName.length() == 0) {
            return;
        }
        Cache cache = (Cache)this.caches.remove(cacheName);
        if (cache != null && cache.getStatus().equals(Status.STATUS_ALIVE)) {
            cache.dispose();
            if (this.cacheManagerEventListener != null) {
                this.cacheManagerEventListener.notifyCacheRemoved(cache.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.status.equals(Status.STATUS_SHUTDOWN)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"CacheManager already shutdown");
            }
            return;
        }
        if (this.cacheManagerPeerProvider != null) {
            this.cacheManagerPeerProvider.dispose();
        }
        if (this.cacheManagerPeerListener != null) {
            this.cacheManagerPeerListener.dispose();
        }
        Class clazz = class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager;
        synchronized (clazz) {
            ALL_CACHE_MANAGER_DISK_STORE_PATHS.remove(this.diskStorePath);
            Collection cacheSet = this.caches.values();
            Iterator iterator = cacheSet.iterator();
            while (iterator.hasNext()) {
                Cache cache = (Cache)iterator.next();
                if (cache == null) continue;
                cache.dispose();
            }
            this.status = Status.STATUS_SHUTDOWN;
            if (this == singleton) {
                singleton = null;
            }
        }
    }

    public synchronized String[] getCacheNames() throws IllegalStateException {
        this.checkStatus();
        String[] list = new String[this.caches.size()];
        return this.caches.keySet().toArray(list);
    }

    private void checkStatus() {
        if (!this.status.equals(Status.STATUS_ALIVE)) {
            throw new IllegalStateException("The CacheManager is not alive.");
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public CacheManagerPeerProvider getCachePeerProvider() {
        return this.cacheManagerPeerProvider;
    }

    public CacheManagerPeerListener getCachePeerListener() {
        return this.cacheManagerPeerListener;
    }

    public CacheManagerEventListener getCacheManagerEventListener() {
        return this.cacheManagerEventListener;
    }

    public void setCacheManagerEventListener(CacheManagerEventListener cacheManagerEventListener) {
        this.cacheManagerEventListener = cacheManagerEventListener;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

