/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapper;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MatchCalculator {
    private static final int SET_BEGIN = 2;
    private static final int SET_END = 5;
    private static final double MAX_VALUE = 1.0;

    public double calculateMatch(String first, String second) {
        Set firstSet = this.buildSets(first);
        Set secondSet = this.buildSets(second);
        double value1 = this.compareSets(firstSet, secondSet);
        double value2 = this.compareSets(secondSet, firstSet);
        return (value1 + value2) / 2.0;
    }

    private Set buildSets(String string) {
        HashSet set = new HashSet();
        char[] chars = string.toUpperCase().toCharArray();
        for (int i = 2; i <= 5; ++i) {
            this.setsOf(i, chars, set);
        }
        return set;
    }

    private void setsOf(int size, char[] chars, Set set) {
        for (int i = 0; i < chars.length - size + 1; ++i) {
            char[] group = new char[size];
            for (int j = 0; j < group.length; ++j) {
                group[j] = chars[i + j];
            }
            set.add(new String(group));
        }
    }

    private double compareSets(Set firstSet, Set secondSet) {
        double value = 1.0;
        double interval = this.calculateInterval(firstSet, secondSet);
        Iterator i = firstSet.iterator();
        while (i.hasNext()) {
            String group = (String)i.next();
            if (secondSet.contains(group)) continue;
            value -= interval;
        }
        return value;
    }

    private double calculateInterval(Set firstSet, Set secondSet) {
        double interval = firstSet.size() > secondSet.size() ? 1.0 / (double)firstSet.size() : 1.0 / (double)secondSet.size();
        return interval;
    }
}

