/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BASE64DecoderStream
extends FilterInputStream {
    private byte[] buffer;
    private int bufsize = 0;
    private int index = 0;
    private byte[] input_buffer = new byte[8190];
    private int input_pos;
    private int input_len;
    private boolean ignoreErrors = false;
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] pem_convert_array = new byte[256];

    static {
        int i = 0;
        while (i < 255) {
            BASE64DecoderStream.pem_convert_array[i] = -1;
            ++i;
        }
        i = 0;
        while (i < pem_array.length) {
            BASE64DecoderStream.pem_convert_array[BASE64DecoderStream.pem_array[i]] = (byte)i;
            ++i;
        }
    }

    public BASE64DecoderStream(InputStream in) {
        super(in);
        this.buffer = new byte[3];
        try {
            String s = System.getProperty("mail.mime.base64.ignoreerrors");
            this.ignoreErrors = s != null && !s.equalsIgnoreCase("false");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public BASE64DecoderStream(InputStream in, boolean ignoreErrors) {
        super(in);
        this.buffer = new byte[3];
        this.ignoreErrors = ignoreErrors;
    }

    public int read() throws IOException {
        if (this.index >= this.bufsize) {
            this.bufsize = this.decode(this.buffer, 0, this.buffer.length);
            if (this.bufsize <= 0) {
                return -1;
            }
            this.index = 0;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] buf, int off, int len) throws IOException {
        i = off;
        while (this.index < this.bufsize && len > 0) {
            buf[off++] = this.buffer[this.index++];
            --len;
        }
        if (this.index >= this.bufsize) {
            this.index = 0;
            this.bufsize = 0;
        }
        if ((l = len / 3 * 3) <= 0) ** GOTO lbl20
        i1 = this.decode(buf, off, l);
        off += i1;
        len -= i1;
        if (i1 == l) ** GOTO lbl20
        if (off == i) {
            return -1;
        }
        return off - i;
        while ((c = this.read()) != -1) {
            buf[off++] = (byte)c;
            --len;
lbl20:
            // 3 sources

            if (len > 0) continue;
        }
        if (off == i) {
            return -1;
        }
        return off - i;
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        return this.in.available() * 3 / 4 + (this.bufsize - this.index);
    }

    private int decode(byte[] buf, int off, int len) throws IOException {
        int k = off;
        while (len >= 3) {
            int l = 0;
            int a = 0;
            while (l < 4) {
                int i = this.getByte();
                if (i == -1 || i == -2) {
                    boolean flag;
                    if (i == -1) {
                        if (l == 0) {
                            return off - k;
                        }
                        if (!this.ignoreErrors) {
                            throw new IOException("Error in encoded stream: needed 4 valid base64 characters but only got " + l + " before EOF" + this.recentChars());
                        }
                        flag = true;
                    } else {
                        if (l < 2 && !this.ignoreErrors) {
                            throw new IOException("Error in encoded stream: needed at least 2 valid base64 characters, but only got " + l + " before padding character (=)" + this.recentChars());
                        }
                        if (l == 0) {
                            return off - k;
                        }
                        flag = false;
                    }
                    int k1 = l - 1;
                    if (k1 == 0) {
                        k1 = 1;
                    }
                    ++l;
                    a <<= 6;
                    while (l < 4) {
                        if (!flag) {
                            i = this.getByte();
                            if (i == -1) {
                                if (!this.ignoreErrors) {
                                    throw new IOException("Error in encoded stream: hit EOF while looking for padding characters (=)" + this.recentChars());
                                }
                            } else if (i != -2 && !this.ignoreErrors) {
                                throw new IOException("Error in encoded stream: found valid base64 character after a padding character (=)" + this.recentChars());
                            }
                        }
                        a <<= 6;
                        ++l;
                    }
                    a >>= 8;
                    if (k1 == 2) {
                        buf[off + 1] = (byte)(a & 0xFF);
                    }
                    buf[off] = (byte)((a >>= 8) & 0xFF);
                    len -= k1;
                    return (off += k1) - k;
                }
                a <<= 6;
                ++l;
                a |= i;
            }
            buf[off + 2] = (byte)(a & 0xFF);
            buf[off + 1] = (byte)((a >>= 8) & 0xFF);
            buf[off] = (byte)((a >>= 8) & 0xFF);
            len -= 3;
            off += 3;
        }
        return off - k;
    }

    private int getByte() throws IOException {
        int i;
        do {
            if (this.input_pos >= this.input_len) {
                try {
                    this.input_len = this.in.read(this.input_buffer);
                }
                catch (EOFException _ex) {
                    return -1;
                }
                if (this.input_len <= 0) {
                    return -1;
                }
                this.input_pos = 0;
            }
            if ((i = this.input_buffer[this.input_pos++] & 0xFF) != 61) continue;
            return -2;
        } while ((i = pem_convert_array[i]) == -1);
        return i;
    }

    private String recentChars() {
        int i;
        String s = "";
        int n = i = this.input_pos <= 10 ? this.input_pos : 10;
        if (i > 0) {
            s = String.valueOf(s) + ", the " + i + " most recent characters were: \"";
            int j = this.input_pos - i;
            while (j < this.input_pos) {
                char c = (char)(this.input_buffer[j] & 0xFF);
                switch (c) {
                    case '\r': {
                        s = String.valueOf(s) + "\\r";
                        break;
                    }
                    case '\n': {
                        s = String.valueOf(s) + "\\n";
                        break;
                    }
                    case '\t': {
                        s = String.valueOf(s) + "\\t";
                        break;
                    }
                    default: {
                        s = c >= ' ' && c < '\u007f' ? String.valueOf(s) + c : String.valueOf(s) + "\\" + c;
                    }
                }
                ++j;
            }
            s = String.valueOf(s) + "\"";
        }
        return s;
    }

    public static byte[] decode(byte[] inbuf) {
        int size = inbuf.length / 4 * 3;
        if (size == 0) {
            return inbuf;
        }
        if (inbuf[inbuf.length - 1] == 61) {
            --size;
            if (inbuf[inbuf.length - 2] == 61) {
                --size;
            }
        }
        byte[] outbuf = new byte[size];
        int inpos = 0;
        int outpos = 0;
        size = inbuf.length;
        while (size > 0) {
            int a = 3;
            int b = pem_convert_array[inbuf[inpos++] & 0xFF];
            b <<= 6;
            b |= pem_convert_array[inbuf[inpos++] & 0xFF];
            b <<= 6;
            if (inbuf[inpos] != 61) {
                b |= pem_convert_array[inbuf[inpos++] & 0xFF];
            } else {
                --a;
            }
            b <<= 6;
            if (inbuf[inpos] != 61) {
                b |= pem_convert_array[inbuf[inpos++] & 0xFF];
            } else {
                --a;
            }
            b <<= 6;
            if (size > 2) {
                inbuf[outpos + 2] = (byte)(b & 0xFF);
            }
            b >>= 8;
            if (size > 1) {
                inbuf[outpos + 1] = (byte)(b & 0xFF);
            }
            inbuf[outpos] = (byte)((b >>= 8) & 0xFF);
            outpos += a;
            size -= 4;
        }
        return outbuf;
    }
}

