/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class SocketFetcher {
    private SocketFetcher() {
    }

    public static Socket getSocket(String host, int port, Properties props, String prefix, boolean useSSL) throws IOException {
        int localport;
        InetAddress localaddr;
        String timeout;
        Socket socket;
        int cto;
        String s;
        block28: {
            if (prefix == null) {
                prefix = "socket";
            }
            if (props == null) {
                props = new Properties();
            }
            s = props.getProperty(String.valueOf(prefix) + ".connectiontimeout", null);
            cto = -1;
            if (s != null) {
                try {
                    cto = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            socket = null;
            String sfClass = props.getProperty(String.valueOf(prefix) + ".socketFactory.class", null);
            timeout = props.getProperty(String.valueOf(prefix) + ".timeout", null);
            String localaddrstr = props.getProperty(String.valueOf(prefix) + ".localaddress", null);
            localaddr = null;
            if (localaddrstr != null) {
                localaddr = InetAddress.getByName(localaddrstr);
            }
            String localportstr = props.getProperty(String.valueOf(prefix) + ".localport", null);
            localport = 0;
            if (localportstr != null) {
                try {
                    localport = Integer.parseInt(localportstr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (sfClass != null && sfClass.length() > 0) {
                int sfPort = -1;
                boolean fb = false;
                String fallback = props.getProperty(String.valueOf(prefix) + ".socketFactory.fallback", null);
                fb = fallback == null || !fallback.equalsIgnoreCase("false");
                String sfPortStr = props.getProperty(String.valueOf(prefix) + ".socketFactory.port", null);
                if (sfPortStr != null) {
                    try {
                        sfPort = Integer.parseInt(sfPortStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                try {
                    ClassLoader cl = SocketFetcher.getContextClassLoader();
                    Class<?> clsSockFact = null;
                    if (cl != null) {
                        try {
                            clsSockFact = cl.loadClass(sfClass);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (clsSockFact == null) {
                        clsSockFact = Class.forName(sfClass);
                    }
                    Method mthGetDefault = clsSockFact.getMethod("getDefault", new Class[0]);
                    SocketFactory socketfactory = (SocketFactory)mthGetDefault.invoke(new Object(), new Object[0]);
                    if (sfPort == -1) {
                        sfPort = port;
                    }
                    socket = SocketFetcher.createSocket(localaddr, localport, s, sfPort, port, socketfactory, useSSL);
                }
                catch (SocketTimeoutException stex) {
                    throw stex;
                }
                catch (Exception ex) {
                    Throwable t;
                    if (fb) break block28;
                    if (ex instanceof InvocationTargetException && (t = ((InvocationTargetException)ex).getTargetException()) instanceof Exception) {
                        ex = (Exception)t;
                    }
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    IOException ioex = new IOException("Couldn't connect using \"" + sfClass + "\" socket factory to host, port: " + s + ", " + sfPort + "; Exception: " + ex);
                    ioex.initCause(ex);
                    throw ioex;
                }
            }
        }
        if (socket == null) {
            socket = SocketFetcher.createSocket(localaddr, localport, s, port, cto, null, useSSL);
        }
        int to = -1;
        if (timeout != null) {
            try {
                to = Integer.parseInt(timeout);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (to >= 0) {
            socket.setSoTimeout(to);
        }
        return socket;
    }

    public static Socket getSocket(String host, int port, Properties props, String prefix) throws IOException {
        return SocketFetcher.getSocket(host, port, props, prefix, false);
    }

    private static Socket createSocket(InetAddress addr, int port, String hostname, int j, int timeout, SocketFactory socketfactory, boolean useSSL) throws IOException {
        Socket socket = socketfactory != null ? socketfactory.createSocket() : (useSSL ? SSLSocketFactory.getDefault().createSocket() : new Socket());
        if (addr != null) {
            socket.bind(new InetSocketAddress(addr, port));
        }
        if (timeout >= 0) {
            socket.connect(new InetSocketAddress(hostname, j), timeout);
        } else {
            socket.connect(new InetSocketAddress(hostname, j));
        }
        return socket;
    }

    public static Socket startTLS(Socket socket) throws IOException {
        InetAddress a = socket.getInetAddress();
        String host = a.getHostName();
        int port = socket.getPort();
        try {
            SSLSocketFactory sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            socket = sslsocketfactory.createSocket(socket, host, port, true);
            ((SSLSocket)socket).setEnabledProtocols(new String[]{"TLSv1"});
        }
        catch (Exception ex) {
            Throwable t;
            if (ex instanceof InvocationTargetException && (t = ((InvocationTargetException)ex).getTargetException()) instanceof Exception) {
                ex = (Exception)t;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            IOException ioex = new IOException("Exception in startTLS: host " + host + ", port " + port + "; Exception: " + ex);
            ioex.initCause(ex);
            throw ioex;
        }
        return socket;
    }

    private static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classloader = null;
                try {
                    classloader = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return classloader;
            }
        });
    }
}

