/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.search.SearchTerm;

public abstract class StringTerm
extends SearchTerm {
    private static final long serialVersionUID = 1274042129007696269L;
    protected String pattern;
    protected boolean ignoreCase;

    protected StringTerm(String pattern) {
        this.pattern = pattern;
        this.ignoreCase = true;
    }

    protected StringTerm(String pattern, boolean ignoreCase) {
        this.pattern = pattern;
        this.ignoreCase = ignoreCase;
    }

    public final String getPattern() {
        return this.pattern;
    }

    public final boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    protected final boolean match(String s) {
        int len = s.length() - this.pattern.length();
        int i = 0;
        while (i <= len) {
            if (s.regionMatches(this.ignoreCase, i, this.pattern, 0, this.pattern.length())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StringTerm)) {
            return false;
        }
        StringTerm st = (StringTerm)obj;
        if (this.ignoreCase) {
            return st.pattern.equalsIgnoreCase(this.pattern) && st.ignoreCase == this.ignoreCase;
        }
        return st.pattern.equals(this.pattern) && st.ignoreCase == this.ignoreCase;
    }

    public int hashCode() {
        return this.ignoreCase ? this.pattern.hashCode() : ~this.pattern.hashCode();
    }
}

