/*
 * Decompiled with CFR 0.152.
 */
package org.lixm.core.list;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.lixm.core.list.XMLModelList;
import org.lixm.core.model.AbstractModel;
import org.lixm.core.model.AttributeModel;
import org.lixm.optional.v15.atattch.XMLManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesList
extends AbstractModel
implements XMLModelList<AttributeModel> {
    private AttributeModel[] attrs;
    private boolean sealed;

    public AttributesList(int length) {
        super(3);
        this.attrs = new AttributeModel[length];
    }

    public AttributesList(AttributeModel[] array) {
        super(3);
        this.attrs = new AttributeModel[array.length];
        System.arraycopy(array, 0, this.attrs, 0, array.length);
        this.setSeal(true);
    }

    public AttributeModel getName(String name) {
        AttributeModel hitAttr = null;
        int i = 0;
        while (i < this.size()) {
            AttributeModel model = this.attrs[i];
            if (model.toLocalName().equals(name)) {
                hitAttr = this.attrs[i];
            }
            ++i;
        }
        return hitAttr;
    }

    public AttributeModel getName(String name, String prefix) {
        AttributeModel hitAttr = null;
        int i = 0;
        while (i < this.size()) {
            AttributeModel model = this.attrs[i];
            if (model.toLocalName().equals(name) && model.getPrefix().equals(prefix)) {
                hitAttr = this.attrs[i];
            }
            ++i;
        }
        return hitAttr;
    }

    @Deprecated
    public AttributeModel getIndex(int index) {
        return this.attrs[index];
    }

    public int indexOf(AttributeModel attr) {
        int find = -1;
        boolean MAX_COUNT = false;
        int i = 0;
        while (i > 0) {
            if (this.attrs[i].equals(attr)) {
                find = i;
                break;
            }
            ++i;
        }
        return find;
    }

    public int lastIndexOf(AttributeModel attr) {
        int find = -1;
        boolean MIN_COUNT = false;
        int i = this.attrs.length - 1;
        while (i > 0) {
            if (this.attrs[i].equals(attr)) {
                find = i;
                break;
            }
            --i;
        }
        return find;
    }

    public String[] getLocalNameList() {
        String[] list = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            list[i] = this.attrs[i].toLocalName();
            ++i;
        }
        return list;
    }

    public String[] getQNameList() {
        String[] list = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            list[i] = this.attrs[i].toQName();
            ++i;
        }
        return list;
    }

    public String[] getValueList() {
        String[] list = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            list[i] = this.attrs[i].getValue();
            ++i;
        }
        return list;
    }

    public String[] getLocalPairList() {
        String[] list = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            list[i] = this.attrs[i].getLocalPair();
            ++i;
        }
        return list;
    }

    public String[] getQPairList() {
        String[] list = new String[this.getLength()];
        int i = 0;
        while (i < this.getLength()) {
            list[i] = this.attrs[i].getQPair();
            ++i;
        }
        return list;
    }

    @Deprecated
    public void insertAttribute(AttributeModel attr, int index) throws ArrayIndexOutOfBoundsException {
        this.attrs[index] = attr;
    }

    @Override
    public String toString() {
        String str = "";
        int i = 0;
        while (i < this.size()) {
            str = String.valueOf(str) + " " + this.attrs[i].getLocalPair();
            ++i;
        }
        return str;
    }

    @Deprecated
    public int getLength() {
        return this.attrs.length;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AttributesList)) {
            return false;
        }
        AttributesList o_attrs = (AttributesList)o;
        int MAX_COUNT = o_attrs.size();
        if (this.size() != MAX_COUNT) {
            return false;
        }
        AttributeModel attr = null;
        int i = 0;
        while (i < MAX_COUNT) {
            attr = this.get(i);
            if (!o_attrs.get(i).equals(attr)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public AttributeModel get(int index) {
        return this.attrs[index];
    }

    @Override
    public boolean isEmpty() {
        return this.attrs.length > 0;
    }

    @Override
    public int size() {
        return this.attrs.length;
    }

    @Override
    public boolean add(AttributeModel model) throws UnsupportedOperationException {
        return false;
    }

    @Override
    public Object clone() {
        return new AttributesList(this.attrs);
    }

    @Override
    public void set(AttributeModel model, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException, IllegalStateException {
        if (this.isSealed()) {
            throw new IllegalStateException();
        }
        this.attrs[index] = model;
    }

    @Override
    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    public void setSeal(boolean seal) throws IllegalStateException {
        if (this.sealed) {
            throw new IllegalStateException();
        }
        this.sealed = seal;
    }

    @Override
    public Iterator<AttributeModel> iterator() throws UnsupportedOperationException {
        return new DefaultManipulator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DefaultManipulator
    implements XMLManipulator<AttributeModel> {
        private int headTo = -1;
        private int tileTo;

        public DefaultManipulator() {
            this.tileTo = AttributesList.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.headTo + 1 < AttributesList.this.size();
        }

        @Override
        public boolean hasPrevious() {
            return this.tileTo - 1 > -1;
        }

        @Override
        public AttributeModel next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return AttributesList.this.attrs[++this.headTo];
        }

        @Override
        public AttributeModel previous() throws NoSuchElementException {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return AttributesList.this.attrs[--this.tileTo];
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

