package org.lixm.optional.v10.atattch;

import java.util.Enumeration;
import java.util.NoSuchElementException;

import org.lixm.core.list.XMLCursor;
import org.lixm.core.list.XMLModelList;

/**
 * <p>モデルリストを<code>Enumeration</code>インターフェースに適応させます。</p>
 * 
 * @author tasogare
 * @version 1.0M2
 * @since 1.0M2
 */
public class XMLEnumeration implements Enumeration {

	XMLModelList list;
	XMLCursor cursor;

	/**
	 * <p>唯一のコンストラクタです。モデルリストをラップします。</p>
	 * @param list <code>Enumeration</code>を適応するモデルリスト
	 */
	public XMLEnumeration(XMLModelList list){
		this.list = list;
		this.cursor = list.getCursor( );
	}

	/**
	 * <p>列挙にさらに要素があるかどうかを判定します。</p>
	 * @return 列挙オブジェクトに 1 つ以上の要素が残っている場合は
	 * <code>true</code>、そうでない場合は<code>false</code>
	 */
	public boolean hasMoreElements() {
		return cursor.hasNext( );
	}

	/**
	 * <p>列挙に 1 つ以上の要素が残っている場合は、次の要素を返します。</p>
	 * @return 列挙の次の要素
	 */
	public Object nextElement() throws NoSuchElementException {

		if(!hasMoreElements( )){
			throw new NoSuchElementException();
		}

		return list.get(cursor.inc( ));
	}

}
