package org.lixm.optional.v10.atattch.impl.jsr172;


import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.lixm.core.common.LIXMPhaseException;
import org.lixm.core.common.XMLModelizer;
import org.lixm.core.list.AttributesList;
import org.lixm.core.list.XMLModelList;
import org.lixm.core.model.AttributeModel;
import org.lixm.core.model.CharactersModel;
import org.lixm.core.model.ElementModel;
import org.lixm.core.model.EndDocumentModel;
import org.lixm.core.model.EndTagModel;
import org.lixm.core.model.ProcessingInstructionModel;
import org.lixm.core.model.StartDocumentModel;
import org.lixm.core.model.StartTagModel;
import org.xml.sax.SAXException;


/**
 * 
 * <p>このクラスはモデライザの<code>JSR-172</code>実装を提供します。</p>
 * 
 * <p><code>JSR-172</code>は<code>JAX-RPC</code>サブセット仕様であり、
 * それには<code>JAXP</code>のサブセット仕様も含まれています。</p>
 * 
 * <p>この実装はその<code>JAXP</code>
 * のサブセット仕様を利用してモデライザを実装します。</p>
 * 
 * @author tasogare
 * @version 1.1.1
 */
public class XMLModelizerImpl implements XMLModelizer{

	//SAX APIs
	private SAXParserFactory spf;
	private SAXParser sax;

	private XMLModelList       list;
	private org.lixm.core.common.InputSource isrc;

	/**
	 * <p>リストを関連付けモデライザの実装を生成します。</p>
	 * <p>このとき、XML名前空間をどう処理するか指定できます。</p>
	 * <p>また、この実装ではリストをモデライザに関連付け出来るのは
	 * コンストラクタのタイミングのみです。</p>
	 * 
	 * @param list 関連付けるリスト
	 * @param nsaware XML in Namespaceをどう処理するか？
	 * @throws LIXMPhaseException プリプロセス処理にJAXP関連の例外が発生した場合
	 * 
	 * @see #getList()
	 * @see #modelize(String)
	 */
    public XMLModelizerImpl(
        XMLModelList list, boolean nsaware) throws LIXMPhaseException
    {
        this.list = list;

        spf = SAXParserFactory.newInstance( );
        spf.setNamespaceAware(nsaware);

        try {
			sax = spf.newSAXParser( );
		} catch ( ParserConfigurationException e ) {
			panic("", e, LIXMPhaseException.PHASE_PREPROCESS);
		} catch ( SAXException e ) {
			panic("", e, LIXMPhaseException.PHASE_PREPROCESS);
		}
    }

    /**
     * <p>関連付けられたモデルリストを返します。</p>
     * 
     * @return 関連付けられたモデルリスト
     */
    public XMLModelList getList() {
        return list;
    }

    /**
     * <p>モデライズ処理を開始します。</p>
     * 
	 * @param name ＸＭＬ文章のパス
	 * @throws LIXMPhaseException モデライズ中に何らかの例外が 発生した場合投げられます。
	 * 他の例外をラップしている可能性があります。
	 */
    public void modelize(
        String name) throws LIXMPhaseException
    {
        if ( name == null ){ 
        	throw new LIXMPhaseException(
        		"XML文章の取得中に例外が発生しました。",
        		new IllegalArgumentException("XML文章のリソース名が無効です。"),
        		LIXMPhaseException.PHASE_PREPROCESS);
        }

        InputStream istr = getClass( ).getResourceAsStream(name);
        isrc = new org.lixm.core.common.InputSource(istr);

        modelize( );
    }

//    public void setList(
//        XMLModelList list)
//    {
//        this.list = list;
//    }

    private void modelize() throws LIXMPhaseException{

    	org.xml.sax.helpers.DefaultHandler handler = new org.xml.sax.helpers.DefaultHandler(){

    		public void characters(char[] ch, int start, int length){
    			list.add(new CharactersModel(new String(ch, start, length)));
    		}

    		public void endDocument(){
    			list.add(new EndDocumentModel(isrc));
    		}

    		public void endElement(String uri, String localName, String qName){

    			//要素モデルの初期化
    			String pref = "";
    			if(!qName.equals("") || qName.length( ) != 0){
    				pref = (qName.indexOf(":") != -1) ?
    					qName.substring(0, qName.indexOf(":")) : "";
    			}
    			ElementModel elemModel = new ElementModel(localName, pref, uri);

    			list.add(new EndTagModel(elemModel));
    		}

    		public void endPrefixMapping(String prefix){}

    		public void ignorableWhitespace(char[] ch, int start, int length){
    			list.add(new CharactersModel(new String(ch, start, length)));
    		}

    		public void processingInstruction(String target, String data){
    			list.add(new ProcessingInstructionModel(target, data));
    		}

    		public void setDocumentLocator(org.xml.sax.Locator locator){}

    		public void skippedEntity(String name){
    			System.out.println("skipped entity by " + name);
    		}

    		public void startDocument(){
    			list.add(new StartDocumentModel(isrc));
    		}

    		public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes atts){

    			//要素モデルの初期化
    			String pref = "";
    			if(!qName.equals("") || qName.length( ) != 0){
    				pref = (qName.indexOf(":") != -1) ?
    					qName.substring(0, qName.indexOf(":")) : "";
    			}
    			ElementModel elemModel = new ElementModel(localName, pref, uri);

    			//属性リストの初期化と開始タグの初期化
//    			AttributeModel[] attributeModes;
    			if(atts.getLength( ) != 0 ){

    				pref = "";

    				String attqName = "";
    				String name = "";
    				String value = "";
    				String id = "";

    				//属性モデルの初期化
    				AttributeModel[] attributeModes = new AttributeModel[atts.getLength( )];

    				for(int i=0; i<atts.getLength( ); i++){

    					name = atts.getLocalName(i);
    					value = atts.getValue(i);

    					attqName = atts.getQName(i);
    					if(!attqName.equals("") || attqName.length( ) != 0){
    						pref = (qName.indexOf(":") != -1) ?
    							attqName.substring(0, attqName.indexOf(":")) : "";
    					}
    					id = atts.getURI(i);

    					attributeModes[i] = new AttributeModel(name, value, pref, id);
    				}

    				pref = null;
    				attqName = null;
    				name = null;
    				value = null;
    				id = null;

    				list.add(new StartTagModel(elemModel, new AttributesList(attributeModes)));

    			}else{
    				list.add(new StartTagModel(elemModel));
    			}
    		}

    		public void startPrefixMapping(String prefix, String uri){}

    	};

    	try {
    	org.xml.sax.InputSource saxInput = new org.xml.sax.InputSource();
    	saxInput.setByteStream(isrc.getByteStream());
    	saxInput.setCharacterStream(isrc.getCharacterStream());
    	saxInput.setEncoding(isrc.getEncoding());
    	saxInput.setPublicId(isrc.getPublicId());
    	saxInput.setSystemId(isrc.getSystemId());
    		sax.parse(saxInput, handler);
        } catch ( SAXException e ) {
			panic("モデライズ中に例外が発生しました。", e, LIXMPhaseException.PHASE_MODELIZE);
		} catch ( IOException e ) {
			panic("モデライズ中に例外が発生しました。", e, LIXMPhaseException.PHASE_MODELIZE);
		} finally {

			spf = null;
			sax = null;

//			try {
//				isrc.getByteStream( ).close( );
//			} catch ( IOException e ) {
//				panic("モデライズ終了時に例外が発生しました。", e);
//			}
        }

    }

    private void panic(
        String msg, Exception e, byte phase) throws LIXMPhaseException
    {
        throw new LIXMPhaseException(msg, e, phase);
    }
}
