package org.lixm.optional.v15.model;

import org.lixm.optional.v16.framework.model.ProcessingInstructionModelImpl;

/**
 * <p>xml-stylesheet߂T|[g܂B</p>
 * 
 * @author tasogare
 * @version 1.7.1
 * @since 1.5
 */
public class XmlStyleSheetPI extends ProcessingInstructionModelImpl {

    private String href;
    private String type;
    private String title;
    private String media;
    private String charset;
    private String alternate;

    /**
     * <p>߂̃^[Qbgƃf[^w肵ď܂B</p>
     * @param target ^[Qbg
     * @param data f[^
     */
    public XmlStyleSheetPI(
        String target, String data)
    {
        super(target, data);
        String[] attrs = data.split(" ");

        for(byte i=0; i<attrs.length; i++){
            String par = (attrs[i].trim( ));
            if(par.startsWith("href")){
                href = par.substring(par.indexOf('=')+1, par.lastIndexOf('"'));
            }else if(par.startsWith("type")){
               type = par.substring(par.indexOf('=')+1, par.lastIndexOf('"'));
            }else if(par.startsWith("title")){
               title = par.substring(par.indexOf('=')+1, par.lastIndexOf('"'));
            }else if(par.startsWith("media")){
               media = par.substring(par.indexOf('=')+1, par.lastIndexOf('"'));
            }else if(par.startsWith("charset")){
               charset = par.substring(par.indexOf('=')+1, par.lastIndexOf('"'));
            }else if(par.startsWith("alternate")){
               alternate = par.substring(par.indexOf('=')+1, par.lastIndexOf('"'));
            }
        }
    }

    /**
     * <p>e[𒼐ڎw肵ď܂</p>
     * @param href
     * @param type 
     * @param title 
     * @param media 
     * @param charset 
     * @param alternate 
     */
    public XmlStyleSheetPI(String href, String type, String title, String media, String charset, String alternate){
        super("xml-stylesheet",
            "href=\"" + href + "\" " +
            "type=\"" + type + "\" " +
            "title=\"" + title + "\" " +
            "media=\"" + media + "\" " +
            "charset=\"" + charset + "\" " +
            "alternate=\"" + alternate + "\" "
            );

        this.href = href;
        this.type = type;
        this.title = title;
        this.media = media;
        this.charset = charset;
        this.alternate = alternate;
    }

    /**
     * ̃X^CV[gւ̂̂H
     * @return փX^CV[gH
     */
    public boolean isAlternate(){
        return alternate.equals("yes");
    }

    /**
     * [alternatȇl擾܂B
     * @return [̒lł
     */
    public String getAlternate() {
        return alternate;
    }

    /**
     * [charset̑l擾܂B
     * @return [̒lł
     */
    public String getCharset() {
        return charset;
    }

    /**
     * [href̑l擾܂B
     * @return [̒lł
     */
    public String getHref() {
        return href;
    }

    /**
     * [mediȃl擾܂B
     * @return [̒lł
     */
    public String getMedia() {
        return media;
    }

    /**
     * [titlȇl擾܂B
     * @return [̒lł
     */
    public String getTitle() {
        return title;
    }


    /**
     * [typȇl擾܂B
     * @return [̒lł
     */    
    public String getType() {
        return type;
    }
}
